/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2.features;

import com.google.common.annotations.Beta;
import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import org.jclouds.Fallbacks;
import org.jclouds.collect.PagedIterable;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.auth.filters.AuthenticateRequest;
import org.jclouds.openstack.neutron.v2.domain.FloatingIP;
import org.jclouds.openstack.neutron.v2.domain.FloatingIPs;
import org.jclouds.openstack.neutron.v2.fallbacks.EmptyFloatingIPsFallback;
import org.jclouds.openstack.neutron.v2.functions.FloatingIPsToPagedIterable;
import org.jclouds.openstack.neutron.v2.functions.ParseFloatingIPs;
import org.jclouds.openstack.v2_0.options.PaginationOptions;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.annotations.WrapWith;

@Path(value="/floatingips")
@RequestFilters(value={AuthenticateRequest.class})
@Consumes(value={"application/json"})
@Beta
public interface FloatingIPApi {
    @Named(value="floatingip:list")
    @GET
    @Transform(value=FloatingIPsToPagedIterable.class)
    @ResponseParser(value=ParseFloatingIPs.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<FloatingIP> list();

    @Named(value="floatingip:list")
    @GET
    @ResponseParser(value=ParseFloatingIPs.class)
    @Fallback(value=EmptyFloatingIPsFallback.class)
    public FloatingIPs list(PaginationOptions var1);

    @Named(value="floatingip:get")
    @GET
    @Path(value="/{id}")
    @SelectJson(value={"floatingip"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public FloatingIP get(@PathParam(value="id") String var1);

    @Named(value="floatingip:create")
    @POST
    @SelectJson(value={"floatingip"})
    public FloatingIP create(@WrapWith(value="floatingip") FloatingIP.CreateFloatingIP var1);

    @Named(value="floatingip:update")
    @PUT
    @Path(value="/{id}")
    @SelectJson(value={"floatingip"})
    public FloatingIP update(@PathParam(value="id") String var1, @WrapWith(value="floatingip") FloatingIP.UpdateFloatingIP var2);

    @Named(value="floatingip:delete")
    @DELETE
    @Path(value="/{id}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean delete(@PathParam(value="id") String var1);
}

