/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2.extensions;

import com.google.common.annotations.Beta;
import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import org.jclouds.Fallbacks;
import org.jclouds.collect.PagedIterable;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.auth.filters.AuthenticateRequest;
import org.jclouds.openstack.neutron.v2.domain.Router;
import org.jclouds.openstack.neutron.v2.domain.RouterInterface;
import org.jclouds.openstack.neutron.v2.domain.Routers;
import org.jclouds.openstack.neutron.v2.fallbacks.EmptyRoutersFallback;
import org.jclouds.openstack.neutron.v2.functions.ParseRouters;
import org.jclouds.openstack.neutron.v2.functions.RouterToPagedIterable;
import org.jclouds.openstack.neutron.v2.options.EmptyOptions;
import org.jclouds.openstack.v2_0.options.PaginationOptions;
import org.jclouds.openstack.v2_0.services.Extension;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.annotations.WrapWith;

@Path(value="/routers")
@RequestFilters(value={AuthenticateRequest.class})
@Consumes(value={"application/json"})
@Extension(of="network", namespace="http://docs.openstack.org/ext/neutron/router/api/v1.0", name="Neutron L3 Router", alias="router")
@Beta
public interface RouterApi {
    @Named(value="router:list")
    @GET
    @Transform(value=RouterToPagedIterable.class)
    @ResponseParser(value=ParseRouters.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Router> list();

    @Named(value="router:list")
    @GET
    @ResponseParser(value=ParseRouters.class)
    @Fallback(value=EmptyRoutersFallback.class)
    public Routers list(PaginationOptions var1);

    @Named(value="router:get")
    @GET
    @Path(value="/{id}")
    @SelectJson(value={"router"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Router get(@PathParam(value="id") String var1);

    @Named(value="router:create")
    @POST
    @SelectJson(value={"router"})
    public Router create(@WrapWith(value="router") Router.CreateRouter var1);

    @Named(value="router:update")
    @PUT
    @Path(value="/{id}")
    @SelectJson(value={"router"})
    public Router update(@PathParam(value="id") String var1, @WrapWith(value="router") Router.UpdateRouter var2);

    @Named(value="router:delete")
    @DELETE
    @Path(value="/{id}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean delete(@PathParam(value="id") String var1);

    @Named(value="router:addInterfaceForSubnet")
    @PUT
    @Path(value="/{id}/add_router_interface")
    @MapBinder(value=EmptyOptions.class)
    public RouterInterface addInterfaceForSubnet(@PathParam(value="id") String var1, @PayloadParam(value="subnet_id") String var2);

    @Named(value="router:addInterfaceForPort")
    @PUT
    @Path(value="/{id}/add_router_interface")
    @MapBinder(value=EmptyOptions.class)
    public RouterInterface addInterfaceForPort(@PathParam(value="id") String var1, @PayloadParam(value="port_id") String var2);

    @Named(value="router:removeInterfaceForSubnet")
    @PUT
    @Path(value="/{id}/remove_router_interface")
    @MapBinder(value=EmptyOptions.class)
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean removeInterfaceForSubnet(@PathParam(value="id") String var1, @PayloadParam(value="subnet_id") String var2);

    @Named(value="router:removeInterfaceForPort")
    @PUT
    @Path(value="/{id}/remove_router_interface")
    @MapBinder(value=EmptyOptions.class)
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean removeInterfaceForPort(@PathParam(value="id") String var1, @PayloadParam(value="port_id") String var2);
}

