/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import jakarta.inject.Named;
import java.beans.ConstructorProperties;
import java.util.Collection;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.neutron.v2.domain.AllocationPool;
import org.jclouds.openstack.neutron.v2.domain.HostRoute;
import org.jclouds.openstack.neutron.v2.domain.IPv6DHCPMode;

public class Subnet {
    private String id;
    private String name;
    @Named(value="network_id")
    private String networkId;
    @Named(value="tenant_id")
    private String tenantId;
    @Named(value="allocation_pools")
    private ImmutableSet<AllocationPool> allocationPools;
    @Named(value="gateway_ip")
    private String gatewayIp;
    @Named(value="ip_version")
    private Integer ipVersion;
    private String cidr;
    @Named(value="enable_dhcp")
    private Boolean enableDhcp;
    @Named(value="dns_nameservers")
    private ImmutableSet<String> dnsNameServers;
    @Named(value="host_routes")
    private ImmutableSet<HostRoute> hostRoutes;
    @Named(value="ipv6_address_mode")
    private IPv6DHCPMode ipv6AddressMode;
    @Named(value="ipv6_ra_mode")
    private IPv6DHCPMode ipv6RaMode;

    @ConstructorProperties(value={"id", "name", "network_id", "tenant_id", "allocation_pools", "gateway_ip", "ip_version", "cidr", "enable_dhcp", "dns_nameservers", "host_routes", "ipv6_address_mode", "ipv6_ra_mode"})
    private Subnet(String id, String name, String networkId, String tenantId, ImmutableSet<AllocationPool> allocationPools, String gatewayIp, Integer ipVersion, String cidr, Boolean enableDhcp, ImmutableSet<String> dnsNameServers, ImmutableSet<HostRoute> hostRoutes, IPv6DHCPMode ipv6AddressMode, IPv6DHCPMode ipv6RaMode) {
        this.id = id;
        this.name = name;
        this.networkId = networkId;
        this.tenantId = tenantId;
        this.allocationPools = allocationPools;
        this.gatewayIp = gatewayIp;
        this.ipVersion = ipVersion;
        this.cidr = cidr;
        this.enableDhcp = enableDhcp;
        this.dnsNameServers = dnsNameServers;
        this.hostRoutes = hostRoutes;
        this.ipv6AddressMode = ipv6AddressMode;
        this.ipv6RaMode = ipv6RaMode;
    }

    private Subnet() {
    }

    private Subnet(Subnet subnet) {
        this(subnet.id, subnet.name, subnet.networkId, subnet.tenantId, subnet.allocationPools, subnet.gatewayIp, subnet.ipVersion, subnet.cidr, subnet.enableDhcp, subnet.dnsNameServers, subnet.hostRoutes, subnet.ipv6AddressMode, subnet.ipv6RaMode);
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getNetworkId() {
        return this.networkId;
    }

    @Nullable
    public String getTenantId() {
        return this.tenantId;
    }

    @Nullable
    public ImmutableSet<AllocationPool> getAllocationPools() {
        return this.allocationPools;
    }

    @Nullable
    public String getGatewayIp() {
        return this.gatewayIp;
    }

    @Nullable
    public Integer getIpVersion() {
        return this.ipVersion;
    }

    @Nullable
    public String getCidr() {
        return this.cidr;
    }

    @Nullable
    public Boolean getEnableDhcp() {
        return this.enableDhcp;
    }

    @Nullable
    public ImmutableSet<String> getDnsNameservers() {
        return this.dnsNameServers;
    }

    @Nullable
    public ImmutableSet<HostRoute> getHostRoutes() {
        return this.hostRoutes;
    }

    @Nullable
    public IPv6DHCPMode getIPv6AddressMode() {
        return this.ipv6AddressMode;
    }

    @Nullable
    public IPv6DHCPMode getIPv6RAMode() {
        return this.ipv6RaMode;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.name, this.networkId, this.tenantId, this.allocationPools, this.gatewayIp, this.ipVersion, this.cidr, this.enableDhcp, this.dnsNameServers, this.hostRoutes, this.ipv6AddressMode, this.ipv6RaMode});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Subnet that = (Subnet)o;
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.networkId, (Object)that.networkId) && Objects.equal((Object)this.tenantId, (Object)that.tenantId) && Objects.equal(this.allocationPools, that.allocationPools) && Objects.equal((Object)this.gatewayIp, (Object)that.gatewayIp) && Objects.equal((Object)this.ipVersion, (Object)that.ipVersion) && Objects.equal((Object)this.cidr, (Object)that.cidr) && Objects.equal((Object)this.enableDhcp, (Object)that.enableDhcp) && Objects.equal(this.dnsNameServers, that.dnsNameServers) && Objects.equal(this.hostRoutes, that.hostRoutes) && Objects.equal((Object)((Object)this.ipv6AddressMode), (Object)((Object)that.ipv6AddressMode)) && Objects.equal((Object)((Object)this.ipv6RaMode), (Object)((Object)that.ipv6RaMode));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("name", (Object)this.name).add("networkId", (Object)this.networkId).add("tenantId", (Object)this.tenantId).add("allocationPools", this.allocationPools).add("gatewayIp", (Object)this.gatewayIp).add("ipVersion", (Object)this.ipVersion).add("cidr", (Object)this.cidr).add("enableDhcp", (Object)this.enableDhcp).add("dnsNameServers", this.dnsNameServers).add("hostRoutes", this.hostRoutes).add("ipv6AddressMode", (Object)this.ipv6AddressMode).add("ipv6RaMode", (Object)this.ipv6RaMode).toString();
    }

    public static CreateBuilder createBuilder(String networkId, String cidr) {
        return new CreateBuilder(networkId, cidr);
    }

    public static UpdateBuilder updateBuilder() {
        return new UpdateBuilder();
    }

    public static class CreateBuilder
    extends Builder<CreateBuilder> {
        private CreateBuilder(String networkId, String cidr) {
            this.subnet.networkId = networkId;
            this.subnet.cidr = cidr;
        }

        public CreateSubnet build() {
            return new CreateSubnet(this.subnet);
        }

        @Override
        protected CreateBuilder self() {
            return this;
        }
    }

    public static class UpdateBuilder
    extends Builder<UpdateBuilder> {
        private UpdateBuilder() {
        }

        public UpdateSubnet build() {
            return new UpdateSubnet(this.subnet);
        }

        @Override
        protected UpdateBuilder self() {
            return this;
        }
    }

    public static class UpdateSubnet
    extends Subnet {
        private UpdateSubnet(Subnet subnet) {
            super(subnet);
        }
    }

    public static class CreateSubnet
    extends Subnet {
        private CreateSubnet(Subnet subnet) {
            super(subnet);
            Preconditions.checkNotNull((Object)subnet.networkId, (Object)"networkId should not be null");
            Preconditions.checkNotNull((Object)subnet.cidr, (Object)"cidr should not be null");
        }
    }

    private static abstract class Builder<ParameterizedBuilderType> {
        protected Subnet subnet = new Subnet();

        private Builder() {
        }

        protected abstract ParameterizedBuilderType self();

        public ParameterizedBuilderType name(String name) {
            this.subnet.name = name;
            return this.self();
        }

        public ParameterizedBuilderType networkId(String networkId) {
            this.subnet.networkId = networkId;
            return this.self();
        }

        public ParameterizedBuilderType tenantId(String tenantId) {
            this.subnet.tenantId = tenantId;
            return this.self();
        }

        public ParameterizedBuilderType allocationPools(Collection<AllocationPool> allocationPools) {
            this.subnet.allocationPools = ImmutableSet.copyOf(allocationPools);
            return this.self();
        }

        public ParameterizedBuilderType gatewayIp(String gatewayIp) {
            this.subnet.gatewayIp = gatewayIp;
            return this.self();
        }

        public ParameterizedBuilderType ipVersion(int ipVersion) {
            this.subnet.ipVersion = ipVersion;
            return this.self();
        }

        public ParameterizedBuilderType cidr(String cidr) {
            this.subnet.cidr = cidr;
            return this.self();
        }

        public ParameterizedBuilderType enableDhcp(Boolean enableDhcp) {
            this.subnet.enableDhcp = enableDhcp;
            return this.self();
        }

        public ParameterizedBuilderType dnsNameServers(ImmutableSet<String> dnsNameServers) {
            this.subnet.dnsNameServers = dnsNameServers;
            return this.self();
        }

        public ParameterizedBuilderType hostRoutes(ImmutableSet<HostRoute> hostRoutes) {
            this.subnet.hostRoutes = hostRoutes;
            return this.self();
        }

        public ParameterizedBuilderType ipv6RaMode(IPv6DHCPMode ipv6RaMode) {
            this.subnet.ipv6RaMode = ipv6RaMode;
            return this.self();
        }

        public ParameterizedBuilderType ipv6AddressMode(IPv6DHCPMode ipv6AddressMode) {
            this.subnet.ipv6AddressMode = ipv6AddressMode;
            return this.self();
        }
    }
}

