/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import jakarta.inject.Named;
import java.beans.ConstructorProperties;
import org.jclouds.javax.annotation.Nullable;

public class RouterInterface {
    @Named(value="subnet_id")
    protected final String subnetId;
    @Named(value="port_id")
    protected final String portId;

    @ConstructorProperties(value={"subnet_id", "port_id"})
    protected RouterInterface(String subnetId, String portId) {
        this.subnetId = subnetId;
        this.portId = portId;
    }

    @Nullable
    public String getSubnetId() {
        return this.subnetId;
    }

    @Nullable
    public String getPortId() {
        return this.portId;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.subnetId, this.portId});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RouterInterface that = (RouterInterface)RouterInterface.class.cast(obj);
        return Objects.equal((Object)this.subnetId, (Object)that.subnetId) && Objects.equal((Object)this.portId, (Object)that.portId);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper((Object)this).add("subnetId", (Object)this.subnetId).add("portId", (Object)this.portId);
    }

    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromRouterInterface(this);
    }

    public static class Builder {
        protected String subnetId;
        protected String portId;

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public Builder portId(String portId) {
            this.portId = portId;
            return this;
        }

        public RouterInterface build() {
            return new RouterInterface(this.subnetId, this.portId);
        }

        public Builder fromRouterInterface(RouterInterface in) {
            return this.subnetId(in.getSubnetId()).portId(in.getPortId());
        }
    }
}

