/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.v2_0.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import jakarta.inject.Named;
import java.beans.ConstructorProperties;
import java.util.Map;
import org.jclouds.openstack.v2_0.domain.RateLimit;

public final class Limits {
    @Named(value="rate")
    private final Iterable<RateLimit> rateLimits;
    @Named(value="absolute")
    private final Map<String, Integer> absoluteLimits;

    @ConstructorProperties(value={"rate", "absolute"})
    private Limits(Iterable<RateLimit> rateLimits, Map<String, Integer> absoluteLimits) {
        this.rateLimits = (Iterable)Preconditions.checkNotNull(rateLimits, (Object)"rateLimits");
        this.absoluteLimits = (Map)Preconditions.checkNotNull(absoluteLimits, (Object)"absoluteLimits");
    }

    public Iterable<RateLimit> getRateLimits() {
        return this.rateLimits;
    }

    public Map<String, Integer> getAbsoluteLimits() {
        return this.absoluteLimits;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.rateLimits, this.absoluteLimits});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Limits that = (Limits)Limits.class.cast(obj);
        return Objects.equal(this.rateLimits, that.rateLimits) && Objects.equal(this.absoluteLimits, that.absoluteLimits);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("rateLimits", this.rateLimits).add("absoluteLimits", this.absoluteLimits).toString();
    }
}

