/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v3.domain;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import java.util.Date;
import java.util.List;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;
import org.jclouds.openstack.keystone.auth.domain.AuthInfo;
import org.jclouds.openstack.keystone.v3.domain.AutoValue_Token;
import org.jclouds.openstack.keystone.v3.domain.Catalog;
import org.jclouds.openstack.keystone.v3.domain.User;

@AutoValue
public abstract class Token
implements AuthInfo {
    @Nullable
    public abstract String id();

    public abstract List<String> methods();

    @Nullable
    public abstract Date expiresAt();

    @Nullable
    public abstract Object extras();

    @Nullable
    public abstract List<Catalog> catalog();

    @Nullable
    public abstract List<String> auditIds();

    public abstract User user();

    public abstract Date issuedAt();

    @Override
    public String getAuthToken() {
        return this.id();
    }

    @SerializedNames(value={"id", "methods", "expires_at", "extras", "catalog", "audit_ids", "user", "issued_at"})
    private static Token create(String id, List<String> methods, Date expiresAt, Object extras, List<Catalog> catalog, List<String> auditIds, User user, Date issuedAt) {
        return Token.builder().id(id).methods(methods).expiresAt(expiresAt).extras(extras).catalog(catalog).auditIds(auditIds).user(user).issuedAt(issuedAt).build();
    }

    Token() {
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_Token.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder id(String var1);

        public abstract Builder methods(List<String> var1);

        public abstract Builder expiresAt(Date var1);

        public abstract Builder extras(Object var1);

        public abstract Builder catalog(List<Catalog> var1);

        public abstract Builder auditIds(List<String> var1);

        public abstract Builder user(User var1);

        public abstract Builder issuedAt(Date var1);

        abstract List<Catalog> catalog();

        abstract List<String> methods();

        abstract List<String> auditIds();

        abstract Token autoBuild();

        public Token build() {
            return this.catalog((List<Catalog>)(this.catalog() != null ? ImmutableList.copyOf(this.catalog()) : ImmutableList.of())).methods((List<String>)(this.methods() != null ? ImmutableList.copyOf(this.methods()) : ImmutableList.of())).auditIds((List<String>)(this.auditIds() != null ? ImmutableList.copyOf(this.auditIds()) : ImmutableList.of())).autoBuild();
        }
    }
}

