/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v3.domain;

import java.net.URI;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.v3.domain.Endpoint;

final class AutoValue_Endpoint
extends Endpoint {
    private final String id;
    private final String region;
    private final String regionId;
    private final String serviceId;
    private final URI url;
    private final Boolean enabled;
    private final String iface;

    private AutoValue_Endpoint(@Nullable String id, @Nullable String region, @Nullable String regionId, @Nullable String serviceId, URI url, @Nullable Boolean enabled, String iface) {
        this.id = id;
        this.region = region;
        this.regionId = regionId;
        this.serviceId = serviceId;
        this.url = url;
        this.enabled = enabled;
        this.iface = iface;
    }

    @Override
    @Nullable
    public String id() {
        return this.id;
    }

    @Override
    @Nullable
    public String region() {
        return this.region;
    }

    @Override
    @Nullable
    public String regionId() {
        return this.regionId;
    }

    @Override
    @Nullable
    public String serviceId() {
        return this.serviceId;
    }

    @Override
    public URI url() {
        return this.url;
    }

    @Override
    @Nullable
    public Boolean enabled() {
        return this.enabled;
    }

    @Override
    public String iface() {
        return this.iface;
    }

    public String toString() {
        return "Endpoint{id=" + this.id + ", region=" + this.region + ", regionId=" + this.regionId + ", serviceId=" + this.serviceId + ", url=" + String.valueOf(this.url) + ", enabled=" + this.enabled + ", iface=" + this.iface + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Endpoint) {
            Endpoint that = (Endpoint)o;
            return (this.id == null ? that.id() == null : this.id.equals(that.id())) && (this.region == null ? that.region() == null : this.region.equals(that.region())) && (this.regionId == null ? that.regionId() == null : this.regionId.equals(that.regionId())) && (this.serviceId == null ? that.serviceId() == null : this.serviceId.equals(that.serviceId())) && this.url.equals(that.url()) && (this.enabled == null ? that.enabled() == null : this.enabled.equals(that.enabled())) && this.iface.equals(that.iface());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.id == null ? 0 : this.id.hashCode();
        h$ *= 1000003;
        h$ ^= this.region == null ? 0 : this.region.hashCode();
        h$ *= 1000003;
        h$ ^= this.regionId == null ? 0 : this.regionId.hashCode();
        h$ *= 1000003;
        h$ ^= this.serviceId == null ? 0 : this.serviceId.hashCode();
        h$ *= 1000003;
        h$ ^= this.url.hashCode();
        h$ *= 1000003;
        h$ ^= this.enabled == null ? 0 : this.enabled.hashCode();
        h$ *= 1000003;
        return h$ ^= this.iface.hashCode();
    }

    @Override
    public Endpoint.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends Endpoint.Builder {
        private String id;
        private String region;
        private String regionId;
        private String serviceId;
        private URI url;
        private Boolean enabled;
        private String iface;

        Builder() {
        }

        private Builder(Endpoint source) {
            this.id = source.id();
            this.region = source.region();
            this.regionId = source.regionId();
            this.serviceId = source.serviceId();
            this.url = source.url();
            this.enabled = source.enabled();
            this.iface = source.iface();
        }

        @Override
        public Endpoint.Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        @Override
        public Endpoint.Builder region(@Nullable String region) {
            this.region = region;
            return this;
        }

        @Override
        public Endpoint.Builder regionId(@Nullable String regionId) {
            this.regionId = regionId;
            return this;
        }

        @Override
        public Endpoint.Builder serviceId(@Nullable String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        @Override
        public Endpoint.Builder url(URI url) {
            if (url == null) {
                throw new NullPointerException("Null url");
            }
            this.url = url;
            return this;
        }

        @Override
        public Endpoint.Builder enabled(@Nullable Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public Endpoint.Builder iface(String iface) {
            if (iface == null) {
                throw new NullPointerException("Null iface");
            }
            this.iface = iface;
            return this;
        }

        @Override
        public Endpoint build() {
            Object missing = "";
            if (this.url == null) {
                missing = (String)missing + " url";
            }
            if (this.iface == null) {
                missing = (String)missing + " iface";
            }
            if (!((String)missing).isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + (String)missing);
            }
            return new AutoValue_Endpoint(this.id, this.region, this.regionId, this.serviceId, this.url, this.enabled, this.iface);
        }
    }
}

