/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v3.auth;

import com.google.inject.name.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import java.io.Closeable;
import org.jclouds.openstack.keystone.auth.AuthenticationApi;
import org.jclouds.openstack.keystone.auth.domain.ApiAccessKeyCredentials;
import org.jclouds.openstack.keystone.auth.domain.AuthInfo;
import org.jclouds.openstack.keystone.auth.domain.PasswordCredentials;
import org.jclouds.openstack.keystone.auth.domain.TenantOrDomainAndCredentials;
import org.jclouds.openstack.keystone.auth.domain.TokenCredentials;
import org.jclouds.openstack.keystone.v3.binders.BindAccessKeyAuthToJsonPayload;
import org.jclouds.openstack.keystone.v3.binders.BindPasswordAuthToJsonPayload;
import org.jclouds.openstack.keystone.v3.binders.BindTokenAuthToJsonPayload;
import org.jclouds.openstack.keystone.v3.domain.Token;
import org.jclouds.openstack.keystone.v3.parsers.ParseTokenFromHttpResponse;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.ResponseParser;

@Consumes(value={"application/json"})
@Path(value="/auth/tokens")
public interface V3AuthenticationApi
extends AuthenticationApi,
Closeable {
    @Override
    @Named(value="token:create")
    @POST
    @ResponseParser(value=ParseTokenFromHttpResponse.class)
    @MapBinder(value=BindPasswordAuthToJsonPayload.class)
    public Token authenticatePassword(TenantOrDomainAndCredentials<PasswordCredentials> var1);

    @Override
    @Named(value="token:create")
    @POST
    @ResponseParser(value=ParseTokenFromHttpResponse.class)
    @MapBinder(value=BindTokenAuthToJsonPayload.class)
    public Token authenticateToken(TenantOrDomainAndCredentials<TokenCredentials> var1);

    @Override
    @Named(value="token:create")
    @POST
    @ResponseParser(value=ParseTokenFromHttpResponse.class)
    @MapBinder(value=BindAccessKeyAuthToJsonPayload.class)
    public AuthInfo authenticateAccessKey(TenantOrDomainAndCredentials<ApiAccessKeyCredentials> var1);
}

