/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.options;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import java.util.Map;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToJsonPayload;

public class CreateUserOptions
implements MapBinder {
    @Inject
    private BindToJsonPayload jsonBinder;
    private String tenant;
    private String password;
    private String email;
    private boolean enabled;

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof CreateUserOptions) {
            CreateUserOptions other = (CreateUserOptions)CreateUserOptions.class.cast(object);
            return Objects.equal((Object)this.tenant, (Object)other.tenant) && Objects.equal((Object)this.password, (Object)other.password) && Objects.equal((Object)this.email, (Object)other.email) && Objects.equal((Object)this.enabled, (Object)other.enabled);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.tenant, this.password, this.email, this.enabled});
    }

    protected MoreObjects.ToStringHelper string() {
        MoreObjects.ToStringHelper toString = MoreObjects.toStringHelper((String)"").omitNullValues();
        toString.add("tenant", (Object)this.tenant);
        toString.add("password", (Object)this.password);
        toString.add("email", (Object)this.email);
        toString.add("enabled", (Object)this.enabled);
        return toString;
    }

    public String toString() {
        return this.string().toString();
    }

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        ServerRequest user = new ServerRequest(Preconditions.checkNotNull((Object)postParams.get("name"), (Object)"name parameter not present").toString(), Preconditions.checkNotNull((Object)postParams.get("password"), (Object)"password parameter not present").toString());
        if (this.email != null) {
            user.email = this.email;
        }
        if (this.password != null) {
            user.password = this.password;
        }
        if (this.tenant != null) {
            user.tenantId = this.tenant;
        }
        user.enabled = this.enabled;
        return this.bindToRequest(request, ImmutableMap.of((Object)"user", (Object)user));
    }

    public String getTenant() {
        return this.tenant;
    }

    public CreateUserOptions tenant(String tenant) {
        this.tenant = tenant;
        return this;
    }

    public String getEmail() {
        return this.email;
    }

    public CreateUserOptions email(String email) {
        this.email = email;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public CreateUserOptions enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        return (R)this.jsonBinder.bindToRequest(request, input);
    }

    static class ServerRequest {
        final String name;
        String tenantId;
        String password;
        String email;
        boolean enabled;

        private ServerRequest(String name, String password) {
            this.name = name;
            this.password = password;
        }
    }

    public static class Builder {
        public static CreateUserOptions tenant(String tenant) {
            CreateUserOptions options = new CreateUserOptions();
            return options.tenant(tenant);
        }

        public static CreateUserOptions email(String email) {
            CreateUserOptions options = new CreateUserOptions();
            return options.email(email);
        }

        public static CreateUserOptions enabled(boolean enabled) {
            CreateUserOptions options = new CreateUserOptions();
            return options.enabled(enabled);
        }
    }
}

