/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.extensions;

import com.google.common.annotations.Beta;
import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import org.jclouds.Fallbacks;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.auth.filters.AuthenticateRequest;
import org.jclouds.openstack.keystone.v2_0.domain.User;
import org.jclouds.openstack.keystone.v2_0.options.CreateUserOptions;
import org.jclouds.openstack.keystone.v2_0.options.UpdateUserOptions;
import org.jclouds.openstack.v2_0.services.Extension;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;

@Consumes(value={"application/json"})
@Extension(of="identity", namespace="http://docs.openstack.org/identity/api/ext/OS-KSADM/v1.0", name="OpenStack Keystone Admin", alias="OS-KSADM")
@RequestFilters(value={AuthenticateRequest.class})
@Path(value="/users")
@Beta
public interface UserAdminApi {
    @Named(value="user:create")
    @POST
    @SelectJson(value={"user"})
    @Nullable
    public User create(@PayloadParam(value="name") String var1, @PayloadParam(value="password") String var2);

    @Named(value="user:create")
    @POST
    @SelectJson(value={"user"})
    @MapBinder(value=CreateUserOptions.class)
    @Nullable
    public User create(@PayloadParam(value="name") String var1, @PayloadParam(value="password") String var2, CreateUserOptions var3);

    @Named(value="user:delete")
    @DELETE
    @Path(value="/{id}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean delete(@PathParam(value="id") String var1);

    @Named(value="user:updateUser")
    @PUT
    @Path(value="/{id}")
    @SelectJson(value={"user"})
    @MapBinder(value=UpdateUserOptions.class)
    @Nullable
    public User update(@PathParam(value="id") String var1, UpdateUserOptions var2);
}

