/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.oauth.v2.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.io.ByteSource;
import com.google.common.util.concurrent.UncheckedExecutionException;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import org.jclouds.crypto.Pems;
import org.jclouds.domain.Credentials;
import org.jclouds.location.Provider;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.util.Throwables2;

@Singleton
final class PrivateKeySupplier
implements Supplier<PrivateKey> {
    private final Supplier<Credentials> creds;
    private final LoadingCache<Credentials, PrivateKey> keyCache;

    @Inject
    PrivateKeySupplier(@Provider Supplier<Credentials> creds, PrivateKeyForCredentials loader) {
        this.creds = creds;
        this.keyCache = CacheBuilder.newBuilder().maximumSize(2L).build((CacheLoader)Preconditions.checkNotNull((Object)((Object)loader), (Object)"loader"));
    }

    public PrivateKey get() {
        try {
            return (PrivateKey)this.keyCache.getUnchecked((Object)((Credentials)Preconditions.checkNotNull((Object)((Credentials)this.creds.get()), (Object)"credential supplier returned null")));
        }
        catch (UncheckedExecutionException e) {
            AuthorizationException authorizationException = (AuthorizationException)Throwables2.getFirstThrowableOfType((Throwable)e, AuthorizationException.class);
            if (authorizationException != null) {
                throw authorizationException;
            }
            throw e;
        }
    }

    @VisibleForTesting
    static final class PrivateKeyForCredentials
    extends CacheLoader<Credentials, PrivateKey> {
        PrivateKeyForCredentials() {
        }

        public PrivateKey load(Credentials in) {
            try {
                String privateKeyInPemFormat = (String)Preconditions.checkNotNull((Object)in.credential, (Object)"credential in PEM format");
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                return keyFactory.generatePrivate(Pems.privateKeySpec((ByteSource)ByteSource.wrap((byte[])privateKeyInPemFormat.getBytes(Charsets.UTF_8))));
            }
            catch (NoSuchAlgorithmException e) {
                throw new AssertionError((Object)e);
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
            catch (InvalidKeySpecException e) {
                throw new AuthorizationException("security exception loading credentials. " + e.getMessage(), (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw new AuthorizationException("cannot parse pk. " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

