/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.oauth.v2.config;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.net.URI;
import java.security.PrivateKey;
import java.util.Map;
import org.jclouds.oauth.v2.AuthorizationApi;
import org.jclouds.oauth.v2.config.Authorization;
import org.jclouds.oauth.v2.config.CertificateFingerprintSupplier;
import org.jclouds.oauth.v2.config.CredentialType;
import org.jclouds.oauth.v2.config.PrivateKeySupplier;
import org.jclouds.oauth.v2.domain.CertificateFingerprint;
import org.jclouds.oauth.v2.filters.BearerTokenFromCredentials;
import org.jclouds.oauth.v2.filters.ClientCredentialsJWTBearerTokenFlow;
import org.jclouds.oauth.v2.filters.ClientCredentialsSecretFlow;
import org.jclouds.oauth.v2.filters.JWTBearerTokenFlow;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.config.BinderUtils;

public final class OAuthModule
extends AbstractModule {
    protected void configure() {
        BinderUtils.bindHttpApi((Binder)this.binder(), AuthorizationApi.class);
        this.bind(CredentialType.class).toProvider(CredentialTypeFromPropertyOrDefault.class);
        this.bind((TypeLiteral)new TypeLiteral<Supplier<PrivateKey>>(){}).annotatedWith(Authorization.class).to(PrivateKeySupplier.class);
        this.bind((TypeLiteral)new TypeLiteral<Supplier<CertificateFingerprint>>(){}).annotatedWith(Authorization.class).to(CertificateFingerprintSupplier.class);
    }

    @Provides
    @Authorization
    protected Supplier<URI> oauthEndpoint(@Named(value="oauth.endpoint") String endpoint) {
        return Suppliers.ofInstance((Object)URI.create(endpoint));
    }

    @Provides
    @Singleton
    protected Map<CredentialType, Class<? extends OAuthFilter>> authenticationFlowMap() {
        return ImmutableMap.of((Object)((Object)CredentialType.P12_PRIVATE_KEY_CREDENTIALS), JWTBearerTokenFlow.class, (Object)((Object)CredentialType.BEARER_TOKEN_CREDENTIALS), BearerTokenFromCredentials.class, (Object)((Object)CredentialType.CLIENT_CREDENTIALS_SECRET), ClientCredentialsSecretFlow.class, (Object)((Object)CredentialType.CLIENT_CREDENTIALS_P12_AND_CERTIFICATE), ClientCredentialsJWTBearerTokenFlow.class);
    }

    @Provides
    @Singleton
    protected OAuthFilter authenticationFilterForCredentialType(CredentialType credentialType, Map<CredentialType, Class<? extends OAuthFilter>> authenticationFlows, Injector injector) {
        if (!authenticationFlows.containsKey((Object)credentialType)) {
            throw new IllegalArgumentException("Unsupported credential type: " + String.valueOf((Object)credentialType));
        }
        return (OAuthFilter)injector.getInstance(authenticationFlows.get((Object)credentialType));
    }

    @Singleton
    public static class CredentialTypeFromPropertyOrDefault
    implements Provider<CredentialType> {
        @Inject(optional=true)
        @Named(value="jclouds.oauth.credential-type")
        String credentialType = CredentialType.P12_PRIVATE_KEY_CREDENTIALS.toString();

        public CredentialType get() {
            return CredentialType.fromValue(this.credentialType);
        }
    }
}

