/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.suppliers;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.List;
import org.jclouds.elasticstack.ElasticStackApi;
import org.jclouds.elasticstack.domain.MediaType;
import org.jclouds.elasticstack.domain.StandardDrive;
import org.jclouds.elasticstack.domain.WellKnownImage;
import org.jclouds.elasticstack.suppliers.WellKnownImageSupplier;

@Singleton
public class StandardDiskImageSupplier
implements WellKnownImageSupplier {
    private final ElasticStackApi api;
    private final Function<StandardDrive, WellKnownImage> standardDriveToWellKnownImage;

    @Inject
    StandardDiskImageSupplier(ElasticStackApi api, Function<StandardDrive, WellKnownImage> standardDriveToWellKnownImage) {
        this.api = (ElasticStackApi)Preconditions.checkNotNull((Object)api, (Object)"api");
        this.standardDriveToWellKnownImage = (Function)Preconditions.checkNotNull(standardDriveToWellKnownImage, (Object)"standardDriveToWellKnownImage");
    }

    public List<WellKnownImage> get() {
        ImmutableList.Builder images = ImmutableList.builder();
        for (StandardDrive drive : this.api.listStandardDriveInfo()) {
            if (drive.getMedia() != MediaType.DISK) continue;
            images.add((Object)((WellKnownImage)this.standardDriveToWellKnownImage.apply((Object)drive)));
        }
        return images.build();
    }
}

