/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.functions;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Resource;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Map;
import org.jclouds.elasticstack.domain.Device;
import org.jclouds.elasticstack.domain.NIC;
import org.jclouds.elasticstack.domain.Server;
import org.jclouds.logging.Logger;
import org.jclouds.rest.annotations.ApiVersion;

@Singleton
public class ServerToMap
implements Function<Server, Map<String, String>> {
    @Resource
    protected Logger logger = Logger.NULL;
    @ApiVersion
    private final String apiVersion;

    @Inject
    public ServerToMap(@ApiVersion String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public Map<String, String> apply(Server from) {
        Preconditions.checkNotNull((Object)from, (Object)"server");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"name", (Object)from.getName());
        builder.put((Object)"cpu", (Object)("" + from.getCpu()));
        if (from.getSmp() != null) {
            builder.put((Object)"smp", (Object)("" + from.getSmp()));
        } else {
            builder.put((Object)"smp", (Object)"auto");
        }
        builder.put((Object)"mem", (Object)("" + from.getMem()));
        builder.put((Object)"persistent", (Object)("" + from.isPersistent()));
        if (!from.getBootDeviceIds().isEmpty()) {
            builder.put((Object)"boot", (Object)Joiner.on((char)' ').join(from.getBootDeviceIds()));
        }
        for (Map.Entry<String, ? extends Device> entry : from.getDevices().entrySet()) {
            builder.put((Object)entry.getKey(), (Object)entry.getValue().getDriveUuid());
            builder.put((Object)(entry.getKey() + ":media"), (Object)entry.getValue().getMediaType().toString());
        }
        int nicId = 0;
        for (NIC nic : from.getNics()) {
            builder.put((Object)("nic:" + nicId + ":model"), (Object)nic.getModel().toString());
            if (nic.getDhcp() != null) {
                builder.put((Object)("nic:" + nicId + ":dhcp"), (Object)nic.getDhcp());
            }
            if (nic.getVlan() != null) {
                builder.put((Object)("nic:" + nicId + ":vlan"), (Object)nic.getVlan());
            }
            if (nic.getMac() != null) {
                this.logger.trace("setting mac on network interfaces not supported: %s", new Object[]{nic});
            }
            ++nicId;
        }
        String string = from.getVnc().getIp();
        if (this.apiVersion.equals("2.0")) {
            builder.put((Object)"vnc", (Object)"auto");
        } else {
            builder.put((Object)"vnc:ip", (Object)(string == null ? "auto" : string));
        }
        if (from.getVnc().getPassword() != null) {
            builder.put((Object)"password", (Object)from.getVnc().getPassword());
        }
        if (from.getVnc().isTls()) {
            builder.put((Object)"vnc:tls", (Object)"on");
        }
        if (!from.getTags().isEmpty()) {
            builder.put((Object)"tags", (Object)Joiner.on((char)' ').join(from.getTags()));
        }
        for (Map.Entry<String, String> entry : from.getUserMetadata().entrySet()) {
            builder.put((Object)("user:" + entry.getKey()), (Object)entry.getValue());
        }
        return builder.build();
    }
}

