/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.functions;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Map;
import org.jclouds.elasticstack.domain.Model;
import org.jclouds.elasticstack.domain.NIC;
import org.jclouds.rest.annotations.ApiVersion;

@Singleton
public class MapToNICs
implements Function<Map<String, String>, List<NIC>> {
    private String apiVersion;

    @Inject
    public MapToNICs(@ApiVersion String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public List<NIC> apply(Map<String, String> from) {
        ImmutableList.Builder nics = ImmutableList.builder();
        for (int id : new int[]{0, 1}) {
            String key = String.format("nic:%d", id);
            if (!from.containsKey(key + ":model")) break;
            NIC.Builder nicBuilder = new NIC.Builder();
            String ip = this.getDhcpIp(from, key);
            nicBuilder.dhcp(ip);
            nicBuilder.model(Model.fromValue(from.get(key + ":model")));
            nicBuilder.vlan(from.get(key + ":vlan"));
            nicBuilder.mac(from.get(key + ":mac"));
            if (from.containsKey(key + ":block")) {
                nicBuilder.block(Splitter.on((char)' ').split((CharSequence)from.get(key + ":block")));
            }
            nics.add((Object)nicBuilder.build());
        }
        return nics.build();
    }

    private String getDhcpIp(Map<String, String> from, String key) {
        if (this.apiVersion.equals("2.0")) {
            String ip = from.get(key + ":dhcp:ip");
            return ip == null ? "auto" : ip;
        }
        String ip = from.get(key + ":dhcp");
        return ip == null ? "auto" : ip;
    }
}

