/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.domain;

import com.google.common.base.Preconditions;
import org.jclouds.elasticstack.domain.Device;
import org.jclouds.elasticstack.domain.MediaType;

public class IDEDevice
extends Device {
    private final int bus;
    private final int unit;

    public IDEDevice(String driveUuid, MediaType mediaType, int bus, int unit) {
        super(driveUuid, mediaType);
        Preconditions.checkArgument((bus == 0 || bus == 1 ? 1 : 0) != 0, (Object)"bus must be 0 or 1");
        Preconditions.checkArgument((unit == 0 || unit == 1 ? 1 : 0) != 0, (Object)"unit must be 0 or 1");
        this.bus = bus;
        this.unit = unit;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.bus;
        result = 31 * result + this.unit;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IDEDevice other = (IDEDevice)obj;
        if (this.bus != other.bus) {
            return false;
        }
        return this.unit == other.unit;
    }

    @Override
    public String getId() {
        return String.format("ide:%d:%d", this.bus, this.unit);
    }

    public int getBus() {
        return this.bus;
    }

    public int getUnit() {
        return this.unit;
    }

    @Override
    public String toString() {
        return "[id=" + this.getId() + ", driveUuid=" + this.driveUuid + ", mediaType=" + String.valueOf((Object)this.mediaType) + "]";
    }

    public static class Builder
    extends Device.Builder {
        private final int bus;
        private final int unit;

        public Builder(int bus, int unit) {
            this.bus = bus;
            this.unit = unit;
        }

        @Override
        public Device build() {
            return new IDEDevice(this.uuid, this.mediaType, this.bus, this.unit);
        }
    }
}

