/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import com.google.common.base.Supplier;
import com.google.common.collect.Sets;
import jakarta.annotation.Resource;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.Set;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.ec2.domain.PublicIpInstanceIdPair;
import org.jclouds.ec2.xml.TagSetHandler;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.location.Region;
import org.jclouds.logging.Logger;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class DescribeAddressesResponseHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Set<PublicIpInstanceIdPair>> {
    @Resource
    protected Logger logger = Logger.NULL;
    private Set<PublicIpInstanceIdPair> pairs = Sets.newLinkedHashSet();
    private String ipAddress;
    private StringBuilder currentText = new StringBuilder();
    @Inject
    @Region
    Supplier<String> defaultRegion;
    private String allocationId;
    private String instanceId;
    private final TagSetHandler tagSetHandler;
    private boolean inTagSet;
    private Map<String, String> tagResults;

    @Inject
    DescribeAddressesResponseHandler(TagSetHandler tagSetHandler) {
        this.tagSetHandler = tagSetHandler;
    }

    public void startElement(String uri, String name, String qName, Attributes attrs) {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"tagSet")) {
            this.inTagSet = true;
        }
        if (this.inTagSet) {
            this.tagSetHandler.startElement(uri, name, qName, attrs);
        }
    }

    protected String currentOrNull() {
        String returnVal = this.currentText.toString().trim();
        return returnVal.equals("") ? null : returnVal;
    }

    public void endElement(String uri, String name, String qName) {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"tagSet")) {
            this.inTagSet = false;
            this.tagResults = this.tagSetHandler.getResult();
        } else if (this.inTagSet) {
            this.tagSetHandler.endElement(uri, name, qName);
        } else if (qName.equals("publicIp")) {
            this.ipAddress = this.currentOrNull();
        } else if (qName.equals("instanceId")) {
            this.instanceId = this.currentOrNull();
        } else if (qName.equals("allocationId")) {
            this.allocationId = this.currentOrNull();
        } else if (qName.equals("item")) {
            String region = AWSUtils.findRegionInArgsOrNull((GeneratedHttpRequest)this.getRequest());
            if (region == null) {
                region = (String)this.defaultRegion.get();
            }
            this.pairs.add(new PublicIpInstanceIdPair(region, this.ipAddress, this.instanceId, this.allocationId, this.tagResults));
            this.ipAddress = null;
            this.instanceId = null;
            this.allocationId = null;
            this.tagResults = null;
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inTagSet) {
            this.tagSetHandler.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }

    public Set<PublicIpInstanceIdPair> getResult() {
        return this.pairs;
    }
}

