/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.suppliers;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.features.AvailabilityZoneAndRegionApi;
import org.jclouds.ec2.options.DescribeRegionsOptions;
import org.jclouds.location.suppliers.RegionIdToURISupplier;
import org.jclouds.location.suppliers.fromconfig.RegionIdsFromConfiguration;

public final class DescribeRegionsForRegionURIs
implements RegionIdToURISupplier {
    private final EC2Api api;
    private final Set<String> whitelistedRegionIds;

    @Inject
    DescribeRegionsForRegionURIs(EC2Api api, RegionIdsFromConfiguration regionIdsFromConfiguration) {
        this.api = api;
        this.whitelistedRegionIds = regionIdsFromConfiguration.get();
    }

    public Map<String, Supplier<URI>> get() {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (Map.Entry<String, URI> regionUrl : ((AvailabilityZoneAndRegionApi)this.api.getAvailabilityZoneAndRegionApi().get()).describeRegions(new DescribeRegionsOptions[0]).entrySet()) {
            if (!this.whitelistedRegionIds.isEmpty() && !this.whitelistedRegionIds.contains(regionUrl.getKey())) continue;
            result.put((Object)regionUrl.getKey(), (Object)Suppliers.ofInstance((Object)regionUrl.getValue()));
        }
        return result.build();
    }
}

