/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.features;

import com.google.common.collect.Multimap;
import jakarta.inject.Named;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import java.util.Map;
import java.util.Set;
import org.jclouds.Fallbacks;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.ec2.binders.BindBlockDeviceMappingToIndexedFormParams;
import org.jclouds.ec2.binders.BindFiltersToIndexedFormParams;
import org.jclouds.ec2.binders.IfNotNullBindAvailabilityZoneToFormParam;
import org.jclouds.ec2.domain.BlockDevice;
import org.jclouds.ec2.domain.InstanceStateChange;
import org.jclouds.ec2.domain.Reservation;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.ec2.domain.Volume;
import org.jclouds.ec2.functions.ConvertUnencodedBytesToBase64EncodedString;
import org.jclouds.ec2.options.RunInstancesOptions;
import org.jclouds.ec2.xml.BlockDeviceMappingHandler;
import org.jclouds.ec2.xml.BooleanValueHandler;
import org.jclouds.ec2.xml.DescribeInstancesResponseHandler;
import org.jclouds.ec2.xml.GetConsoleOutputResponseHandler;
import org.jclouds.ec2.xml.InstanceInitiatedShutdownBehaviorHandler;
import org.jclouds.ec2.xml.InstanceStateChangeHandler;
import org.jclouds.ec2.xml.InstanceTypeHandler;
import org.jclouds.ec2.xml.RunInstancesResponseHandler;
import org.jclouds.ec2.xml.StringValueHandler;
import org.jclouds.ec2.xml.UnencodeStringValueHandler;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.functions.RegionToEndpointOrProviderIfNull;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.FormParams;
import org.jclouds.rest.annotations.ParamParser;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SinceApiVersion;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;

@RequestFilters(value={FormSigner.class})
@VirtualHost
public interface InstanceApi {
    @Named(value="DescribeInstances")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DescribeInstances"})
    @XMLResponseParser(value=DescribeInstancesResponseHandler.class)
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<? extends Reservation<? extends RunningInstance>> describeInstancesInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, String ... var2);

    @SinceApiVersion(value="2010-08-31")
    @Named(value="DescribeInstances")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DescribeInstances"})
    @XMLResponseParser(value=DescribeInstancesResponseHandler.class)
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<? extends Reservation<? extends RunningInstance>> describeInstancesInRegionWithFilter(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @BinderParam(value=BindFiltersToIndexedFormParams.class) Multimap<String, String> var2);

    @Named(value="RunInstances")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"RunInstances"})
    @XMLResponseParser(value=RunInstancesResponseHandler.class)
    public Reservation<? extends RunningInstance> runInstancesInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @Nullable @BinderParam(value=IfNotNullBindAvailabilityZoneToFormParam.class) String var2, @FormParam(value="ImageId") String var3, @FormParam(value="MinCount") int var4, @FormParam(value="MaxCount") int var5, RunInstancesOptions ... var6);

    @Named(value="RebootInstances")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"RebootInstances"})
    public void rebootInstancesInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, String ... var2);

    @Named(value="TerminateInstances")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"TerminateInstances"})
    @XMLResponseParser(value=InstanceStateChangeHandler.class)
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<? extends InstanceStateChange> terminateInstancesInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, String ... var2);

    @Named(value="StopInstances")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"StopInstances"})
    @XMLResponseParser(value=InstanceStateChangeHandler.class)
    public Set<? extends InstanceStateChange> stopInstancesInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="Force") boolean var2, String ... var3);

    @Named(value="StartInstances")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"StartInstances"})
    @XMLResponseParser(value=InstanceStateChangeHandler.class)
    public Set<? extends InstanceStateChange> startInstancesInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, String ... var2);

    @Named(value="DescribeInstanceAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"DescribeInstanceAttribute", "userData"})
    @XMLResponseParser(value=UnencodeStringValueHandler.class)
    public String getUserDataForInstanceInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="InstanceId") String var2);

    @Named(value="DescribeInstanceAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"DescribeInstanceAttribute", "rootDeviceName"})
    @XMLResponseParser(value=StringValueHandler.class)
    public String getRootDeviceNameForInstanceInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="InstanceId") String var2);

    @Named(value="DescribeInstanceAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"DescribeInstanceAttribute", "ramdisk"})
    @XMLResponseParser(value=StringValueHandler.class)
    public String getRamdiskForInstanceInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="InstanceId") String var2);

    @Named(value="DescribeInstanceAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"DescribeInstanceAttribute", "kernel"})
    @XMLResponseParser(value=StringValueHandler.class)
    public String getKernelForInstanceInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="InstanceId") String var2);

    @Named(value="DescribeInstanceAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"DescribeInstanceAttribute", "disableApiTermination"})
    @XMLResponseParser(value=BooleanValueHandler.class)
    public boolean isApiTerminationDisabledForInstanceInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="InstanceId") String var2);

    @Named(value="DescribeInstanceAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"DescribeInstanceAttribute", "instanceType"})
    @XMLResponseParser(value=InstanceTypeHandler.class)
    public String getInstanceTypeForInstanceInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="InstanceId") String var2);

    @Named(value="DescribeInstanceAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"DescribeInstanceAttribute", "instanceInitiatedShutdownBehavior"})
    @XMLResponseParser(value=InstanceInitiatedShutdownBehaviorHandler.class)
    public Volume.InstanceInitiatedShutdownBehavior getInstanceInitiatedShutdownBehaviorForInstanceInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="InstanceId") String var2);

    @Named(value="DescribeInstanceAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"DescribeInstanceAttribute", "blockDeviceMapping"})
    @XMLResponseParser(value=BlockDeviceMappingHandler.class)
    public Map<String, BlockDevice> getBlockDeviceMappingForInstanceInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="InstanceId") String var2);

    @Named(value="ResetInstanceAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"ResetInstanceAttribute", "ramdisk"})
    public void resetRamdiskForInstanceInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="InstanceId") String var2);

    @Named(value="ResetInstanceAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"ResetInstanceAttribute", "kernel"})
    public void resetKernelForInstanceInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="InstanceId") String var2);

    @Named(value="ModifyInstanceAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"ModifyInstanceAttribute", "userData"})
    public void setUserDataForInstanceInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="InstanceId") String var2, @FormParam(value="Value") @ParamParser(value=ConvertUnencodedBytesToBase64EncodedString.class) byte[] var3);

    @Named(value="ModifyInstanceAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"ModifyInstanceAttribute", "ramdisk"})
    public void setRamdiskForInstanceInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="InstanceId") String var2, @FormParam(value="Value") String var3);

    @Named(value="ModifyInstanceAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"ModifyInstanceAttribute", "kernel"})
    public void setKernelForInstanceInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="InstanceId") String var2, @FormParam(value="Value") String var3);

    @Named(value="ModifyInstanceAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"ModifyInstanceAttribute", "disableApiTermination"})
    public void setApiTerminationDisabledForInstanceInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="InstanceId") String var2, @FormParam(value="Value") boolean var3);

    @Named(value="ModifyInstanceAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"ModifyInstanceAttribute", "instanceType"})
    public void setInstanceTypeForInstanceInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="InstanceId") String var2, @FormParam(value="Value") String var3);

    @Named(value="ModifyInstanceAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"ModifyInstanceAttribute", "instanceInitiatedShutdownBehavior"})
    public void setInstanceInitiatedShutdownBehaviorForInstanceInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="InstanceId") String var2, @FormParam(value="Value") Volume.InstanceInitiatedShutdownBehavior var3);

    @Named(value="ModifyInstanceAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"ModifyInstanceAttribute"})
    public void setBlockDeviceMappingForInstanceInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="InstanceId") String var2, @BinderParam(value=BindBlockDeviceMappingToIndexedFormParams.class) Map<String, BlockDevice> var3);

    @Named(value="GetConsoleOutput")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"GetConsoleOutput"})
    @XMLResponseParser(value=GetConsoleOutputResponseHandler.class)
    public String getConsoleOutputForInstanceInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="InstanceId") String var2);
}

