/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.features;

import com.google.common.collect.Multimap;
import jakarta.inject.Named;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import java.util.Set;
import org.jclouds.Fallbacks;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.ec2.binders.BindFiltersToIndexedFormParams;
import org.jclouds.ec2.domain.PublicIpInstanceIdPair;
import org.jclouds.ec2.xml.AllocateAddressResponseHandler;
import org.jclouds.ec2.xml.DescribeAddressesResponseHandler;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.functions.RegionToEndpointOrProviderIfNull;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.FormParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SinceApiVersion;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;

@RequestFilters(value={FormSigner.class})
@VirtualHost
public interface ElasticIPAddressApi {
    @Named(value="AllocateAddress")
    @POST
    @Path(value="/")
    @XMLResponseParser(value=AllocateAddressResponseHandler.class)
    @FormParams(keys={"Action"}, values={"AllocateAddress"})
    public String allocateAddressInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1);

    @Named(value="AssociateAddress")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"AssociateAddress"})
    public void associateAddressInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="PublicIp") String var2, @FormParam(value="InstanceId") String var3);

    @Named(value="DisassociateAddress")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DisassociateAddress"})
    public void disassociateAddressInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="PublicIp") String var2);

    @Named(value="ReleaseAddress")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"ReleaseAddress"})
    public void releaseAddressInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="PublicIp") String var2);

    @Named(value="ReleaseAddress")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"ReleaseAddress"})
    public void releaseAddressInRegionByAllocationId(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="AllocationId") String var2);

    @Named(value="DescribeAddresses")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DescribeAddresses"})
    @XMLResponseParser(value=DescribeAddressesResponseHandler.class)
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<PublicIpInstanceIdPair> describeAddressesInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, String ... var2);

    @SinceApiVersion(value="2010-08-31")
    @Named(value="DescribeAddresses")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DescribeAddresses"})
    @XMLResponseParser(value=DescribeAddressesResponseHandler.class)
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<PublicIpInstanceIdPair> describeAddressesInRegionWithFilter(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @BinderParam(value=BindFiltersToIndexedFormParams.class) Multimap<String, String> var2);
}

