/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.features;

import com.google.common.collect.Multimap;
import jakarta.inject.Named;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import java.util.Set;
import org.jclouds.Fallbacks;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.ec2.EC2Fallbacks;
import org.jclouds.ec2.binders.BindFiltersToIndexedFormParams;
import org.jclouds.ec2.binders.BindUserGroupsToIndexedFormParams;
import org.jclouds.ec2.binders.BindUserIdsToIndexedFormParams;
import org.jclouds.ec2.domain.Attachment;
import org.jclouds.ec2.domain.Permission;
import org.jclouds.ec2.domain.Snapshot;
import org.jclouds.ec2.domain.Volume;
import org.jclouds.ec2.options.CreateSnapshotOptions;
import org.jclouds.ec2.options.CreateVolumeOptions;
import org.jclouds.ec2.options.DescribeSnapshotsOptions;
import org.jclouds.ec2.options.DetachVolumeOptions;
import org.jclouds.ec2.xml.AttachmentHandler;
import org.jclouds.ec2.xml.CreateVolumeResponseHandler;
import org.jclouds.ec2.xml.DescribeSnapshotsResponseHandler;
import org.jclouds.ec2.xml.DescribeVolumesResponseHandler;
import org.jclouds.ec2.xml.PermissionHandler;
import org.jclouds.ec2.xml.SnapshotHandler;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.functions.RegionToEndpointOrProviderIfNull;
import org.jclouds.location.functions.ZoneToEndpoint;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.FormParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;

@RequestFilters(value={FormSigner.class})
@VirtualHost
public interface ElasticBlockStoreApi {
    @Named(value="CreateVolume")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"CreateVolume"})
    @XMLResponseParser(value=CreateVolumeResponseHandler.class)
    public Volume createVolumeFromSnapshotInAvailabilityZone(@EndpointParam(parser=ZoneToEndpoint.class) @FormParam(value="AvailabilityZone") String var1, @FormParam(value="SnapshotId") String var2);

    @Named(value="CreateVolume")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"CreateVolume"})
    @XMLResponseParser(value=CreateVolumeResponseHandler.class)
    public Volume createVolumeFromSnapshotInAvailabilityZone(@EndpointParam(parser=ZoneToEndpoint.class) @FormParam(value="AvailabilityZone") String var1, @FormParam(value="Size") int var2, @FormParam(value="SnapshotId") String var3);

    @Named(value="CreateVolume")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"CreateVolume"})
    @XMLResponseParser(value=CreateVolumeResponseHandler.class)
    public Volume createVolumeInAvailabilityZone(@EndpointParam(parser=ZoneToEndpoint.class) @FormParam(value="AvailabilityZone") String var1, @FormParam(value="Size") int var2);

    @Named(value="CreateVolume")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"CreateVolume"})
    @XMLResponseParser(value=CreateVolumeResponseHandler.class)
    public Volume createVolumeInAvailabilityZone(@EndpointParam(parser=ZoneToEndpoint.class) @FormParam(value="AvailabilityZone") String var1, CreateVolumeOptions ... var2);

    @POST
    @Named(value="DescribeVolumes")
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DescribeVolumes"})
    @XMLResponseParser(value=DescribeVolumesResponseHandler.class)
    public Set<Volume> describeVolumesInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, String ... var2);

    @POST
    @Named(value="DescribeVolumes")
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DescribeVolumes"})
    @XMLResponseParser(value=DescribeVolumesResponseHandler.class)
    public Set<Volume> describeVolumesInRegionWithFilter(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @BinderParam(value=BindFiltersToIndexedFormParams.class) Multimap<String, String> var2);

    @Named(value="DeleteVolume")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DeleteVolume"})
    public void deleteVolumeInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="VolumeId") String var2);

    @Named(value="DetachVolume")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DetachVolume"})
    @Fallback(value=EC2Fallbacks.VoidOnVolumeAvailable.class)
    public void detachVolumeInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="VolumeId") String var2, @FormParam(value="Force") boolean var3, DetachVolumeOptions ... var4);

    @Named(value="AttachVolume")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"AttachVolume"})
    @XMLResponseParser(value=AttachmentHandler.class)
    public Attachment attachVolumeInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="VolumeId") String var2, @FormParam(value="InstanceId") String var3, @FormParam(value="Device") String var4);

    @Named(value="CreateSnapshot")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"CreateSnapshot"})
    @XMLResponseParser(value=SnapshotHandler.class)
    public Snapshot createSnapshotInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="VolumeId") String var2, CreateSnapshotOptions ... var3);

    @Named(value="DescribeSnapshots")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DescribeSnapshots"})
    @XMLResponseParser(value=DescribeSnapshotsResponseHandler.class)
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<Snapshot> describeSnapshotsInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, DescribeSnapshotsOptions ... var2);

    @Named(value="DescribeSnapshots")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DescribeSnapshots"})
    @XMLResponseParser(value=DescribeSnapshotsResponseHandler.class)
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<Snapshot> describeSnapshotsInRegionWithFilter(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @BinderParam(value=BindFiltersToIndexedFormParams.class) Multimap<String, String> var2, DescribeSnapshotsOptions ... var3);

    @Named(value="DeleteSnapshot")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DeleteSnapshot"})
    public void deleteSnapshotInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="SnapshotId") String var2);

    @Named(value="ModifySnapshotAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "OperationType", "Attribute"}, values={"ModifySnapshotAttribute", "add", "createVolumePermission"})
    public void addCreateVolumePermissionsToSnapshotInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @BinderParam(value=BindUserIdsToIndexedFormParams.class) Iterable<String> var2, @BinderParam(value=BindUserGroupsToIndexedFormParams.class) Iterable<String> var3, @FormParam(value="SnapshotId") String var4);

    @Named(value="ModifySnapshotAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "OperationType", "Attribute"}, values={"ModifySnapshotAttribute", "remove", "createVolumePermission"})
    public void removeCreateVolumePermissionsFromSnapshotInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @BinderParam(value=BindUserIdsToIndexedFormParams.class) Iterable<String> var2, @BinderParam(value=BindUserGroupsToIndexedFormParams.class) Iterable<String> var3, @FormParam(value="SnapshotId") String var4);

    @Named(value="DescribeSnapshotAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"DescribeSnapshotAttribute", "createVolumePermission"})
    @XMLResponseParser(value=PermissionHandler.class)
    public Permission getCreateVolumePermissionForSnapshotInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="SnapshotId") String var2);

    @Named(value="ResetSnapshotAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"ResetSnapshotAttribute", "createVolumePermission"})
    public void resetCreateVolumePermissionsOnSnapshotInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="SnapshotId") String var2);
}

