/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.domain;

import com.google.common.base.Preconditions;
import org.jclouds.ec2.domain.InstanceState;

public class InstanceStateChange
implements Comparable<InstanceStateChange> {
    private final String region;
    private final String instanceId;
    private final InstanceState currentState;
    private final InstanceState previousState;

    @Override
    public int compareTo(InstanceStateChange o) {
        return this == o ? 0 : this.getInstanceId().compareTo(o.getInstanceId());
    }

    public InstanceStateChange(String region, String instanceId, InstanceState currentState, InstanceState previousState) {
        this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"region");
        this.instanceId = instanceId;
        this.currentState = currentState;
        this.previousState = previousState;
    }

    @Deprecated
    public String getRegion() {
        return this.region;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public InstanceState getCurrentState() {
        return this.currentState;
    }

    public InstanceState getPreviousState() {
        return this.previousState;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.instanceId == null ? 0 : this.instanceId.hashCode());
        result = 31 * result + (this.previousState == null ? 0 : this.previousState.hashCode());
        result = 31 * result + (this.region == null ? 0 : this.region.hashCode());
        result = 31 * result + (this.currentState == null ? 0 : this.currentState.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InstanceStateChange other = (InstanceStateChange)obj;
        if (this.instanceId == null ? other.instanceId != null : !this.instanceId.equals(other.instanceId)) {
            return false;
        }
        if (this.previousState == null ? other.previousState != null : !this.previousState.equals((Object)other.previousState)) {
            return false;
        }
        if (this.region == null ? other.region != null : !this.region.equals(other.region)) {
            return false;
        }
        return !(this.currentState == null ? other.currentState != null : !this.currentState.equals((Object)other.currentState));
    }

    public String toString() {
        return "InstanceStateChange [currentState=" + String.valueOf((Object)this.currentState) + ", instanceId=" + this.instanceId + ", previousState=" + String.valueOf((Object)this.previousState) + ", region=" + this.region + "]";
    }
}

