/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.domain;

public enum ImageAttribute {
    PRODUCT_CODES,
    RAMDISK,
    KERNEL,
    LAUNCH_PERMISSION,
    PLATFORM,
    BLOCK_DEVICE_MAPPING,
    UNRECOGNIZED;


    public String value() {
        switch (this.ordinal()) {
            case 0: {
                return "productCodes";
            }
            case 1: {
                return "ramdisk";
            }
            case 2: {
                return "kernel";
            }
            case 3: {
                return "launchPermission";
            }
            case 4: {
                return "platform";
            }
            case 5: {
                return "blockDeviceMapping";
            }
        }
        throw new IllegalArgumentException("unmapped attribute: " + super.name());
    }

    public String toString() {
        return this.value();
    }

    public static ImageAttribute fromValue(String attribute) {
        if ("productCodes".equals(attribute)) {
            return PRODUCT_CODES;
        }
        if ("ramdisk".equals(attribute)) {
            return RAMDISK;
        }
        if ("kernel".equals(attribute)) {
            return KERNEL;
        }
        if ("launchPermission".equals(attribute)) {
            return LAUNCH_PERMISSION;
        }
        if ("platform".equals(attribute)) {
            return PLATFORM;
        }
        if ("blockDeviceMapping".equals(attribute)) {
            return BLOCK_DEVICE_MAPPING;
        }
        return UNRECOGNIZED;
    }
}

