/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.strategy;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.compute.strategy.RebootNodeStrategy;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.features.InstanceApi;

@Singleton
public class EC2RebootNodeStrategy
implements RebootNodeStrategy {
    private final InstanceApi client;
    private final GetNodeMetadataStrategy getNode;

    @Inject
    protected EC2RebootNodeStrategy(EC2Api client, GetNodeMetadataStrategy getNode) {
        this.client = (InstanceApi)client.getInstanceApi().get();
        this.getNode = getNode;
    }

    public NodeMetadata rebootNode(String id) {
        String[] parts = AWSUtils.parseHandle((String)id);
        String region = parts[0];
        String instanceId = parts[1];
        this.client.rebootInstancesInRegion(region, instanceId);
        return this.getNode.getNode(id);
    }
}

