/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.strategy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Atomics;
import com.google.common.util.concurrent.ListenableFuture;
import jakarta.annotation.Resource;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.compute.config.CustomizationResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.functions.DefaultCredentialsFromImageOrOverridingCredentials;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.strategy.CreateNodesInGroupThenAddToSet;
import org.jclouds.compute.util.ComputeUtils;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.functions.PresentInstances;
import org.jclouds.ec2.compute.options.EC2TemplateOptions;
import org.jclouds.ec2.compute.strategy.CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions;
import org.jclouds.ec2.compute.util.EC2ComputeUtils;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.ec2.features.ElasticIPAddressApi;
import org.jclouds.ec2.features.InstanceApi;
import org.jclouds.ec2.options.RunInstancesOptions;
import org.jclouds.logging.Logger;

@Singleton
public class EC2CreateNodesInGroupThenAddToSet
implements CreateNodesInGroupThenAddToSet {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    @Inject
    @Named(value="jclouds.ec2.auto-allocate-elastic-ips")
    @VisibleForTesting
    boolean autoAllocateElasticIps = false;
    @VisibleForTesting
    final EC2Api client;
    @VisibleForTesting
    final Predicate<AtomicReference<NodeMetadata>> nodeRunning;
    @VisibleForTesting
    final LoadingCache<RegionAndName, String> elasticIpCache;
    @VisibleForTesting
    final CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions createKeyPairAndSecurityGroupsAsNeededAndReturncustomize;
    @VisibleForTesting
    final Function<RunningInstance, NodeMetadata> runningInstanceToNodeMetadata;
    @VisibleForTesting
    final ComputeUtils utils;
    final PresentInstances presentInstances;
    final LoadingCache<RunningInstance, Optional<LoginCredentials>> instanceToCredentials;
    final Map<String, Credentials> credentialStore;
    public static final Function<RunningInstance, RegionAndName> instanceToRegionAndName = new Function<RunningInstance, RegionAndName>(){

        public RegionAndName apply(RunningInstance from) {
            return new RegionAndName(from.getRegion(), from.getId());
        }
    };

    @Inject
    protected EC2CreateNodesInGroupThenAddToSet(EC2Api client, @Named(value="ELASTICIP") LoadingCache<RegionAndName, String> elasticIpCache, @Named(value="jclouds.compute.timeout.node-running") Predicate<AtomicReference<NodeMetadata>> nodeRunning, CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions createKeyPairAndSecurityGroupsAsNeededAndReturncustomize, PresentInstances presentInstances, Function<RunningInstance, NodeMetadata> runningInstanceToNodeMetadata, LoadingCache<RunningInstance, Optional<LoginCredentials>> instanceToCredentials, Map<String, Credentials> credentialStore, ComputeUtils utils) {
        this.client = (EC2Api)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.elasticIpCache = (LoadingCache)Preconditions.checkNotNull(elasticIpCache, (Object)"elasticIpCache");
        this.nodeRunning = (Predicate)Preconditions.checkNotNull(nodeRunning, (Object)"nodeRunning");
        this.presentInstances = (PresentInstances)Preconditions.checkNotNull((Object)presentInstances, (Object)"presentInstances");
        this.createKeyPairAndSecurityGroupsAsNeededAndReturncustomize = (CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions)Preconditions.checkNotNull((Object)createKeyPairAndSecurityGroupsAsNeededAndReturncustomize, (Object)"createKeyPairAndSecurityGroupsAsNeededAndReturncustomize");
        this.runningInstanceToNodeMetadata = (Function)Preconditions.checkNotNull(runningInstanceToNodeMetadata, (Object)"runningInstanceToNodeMetadata");
        this.instanceToCredentials = (LoadingCache)Preconditions.checkNotNull(instanceToCredentials, (Object)"instanceToCredentials");
        this.credentialStore = (Map)Preconditions.checkNotNull(credentialStore, (Object)"credentialStore");
        this.utils = (ComputeUtils)Preconditions.checkNotNull((Object)utils, (Object)"utils");
    }

    public Map<?, ListenableFuture<Void>> execute(String group, int count, Template template, Set<NodeMetadata> goodNodes, Map<NodeMetadata, Exception> badNodes, Multimap<NodeMetadata, CustomizationResponse> customizationResponses) {
        Template mutableTemplate = template.clone();
        Set<RunningInstance> started = this.runInstancesAndWarnOnInvisible(group, count, mutableTemplate);
        if (started.isEmpty()) {
            this.logger.warn("<< unable to start instances(%s)", new Object[]{mutableTemplate});
            return ImmutableMap.of();
        }
        this.populateCredentials(started, template.getOptions());
        if (this.autoAllocateElasticIps) {
            this.blockUntilRunningAndAssignElasticIpsToInstancesOrPutIntoBadMap(started, badNodes);
        }
        return this.utils.customizeNodesAndAddToGoodMapOrPutExceptionIntoBadMap(mutableTemplate.getOptions(), Iterables.transform(started, this.runningInstanceToNodeMetadata), goodNodes, badNodes, customizationResponses);
    }

    private Set<RunningInstance> runInstancesAndWarnOnInvisible(String group, int count, Template mutableTemplate) {
        Set<RunningInstance> started = this.createKeyPairAndSecurityGroupsAsNeededThenRunInstances(group, count, mutableTemplate);
        ImmutableSet startedIds = ImmutableSet.copyOf((Iterable)Iterables.transform(started, instanceToRegionAndName));
        if (startedIds.isEmpty()) {
            return ImmutableSet.copyOf(started);
        }
        this.logger.debug("<< started instances(%s)", new Object[]{startedIds});
        Set<RunningInstance> visible = this.presentInstances.apply((Set<RegionAndName>)startedIds);
        ImmutableSet visibleIds = ImmutableSet.copyOf((Iterable)Iterables.transform(visible, instanceToRegionAndName));
        this.logger.trace("<< visible instances(%s)", new Object[]{visibleIds});
        Sets.SetView invisibleIds = Sets.difference((Set)startedIds, (Set)visibleIds);
        if (!invisibleIds.isEmpty()) {
            this.logger.warn("<< not api visible instances(%s)", new Object[]{invisibleIds});
        }
        return started;
    }

    private void populateCredentials(Set<RunningInstance> input, TemplateOptions options) {
        Object instance2;
        LoginCredentials credentials = null;
        Iterator<RunningInstance> iterator = input.iterator();
        while (iterator.hasNext() && (credentials = (LoginCredentials)((Optional)this.instanceToCredentials.getUnchecked(instance2 = iterator.next())).orNull()) == null) {
        }
        if ((credentials = DefaultCredentialsFromImageOrOverridingCredentials.overrideDefaultCredentialsWithOptionsIfPresent(credentials, (RunScriptOptions)options)) != null) {
            for (Object instance2 : Iterables.transform(input, instanceToRegionAndName)) {
                this.credentialStore.put("node#" + ((RegionAndName)instance2).slashEncode(), (Credentials)credentials);
            }
        }
    }

    private void blockUntilRunningAndAssignElasticIpsToInstancesOrPutIntoBadMap(Set<RunningInstance> input, Map<NodeMetadata, Exception> badNodes) {
        ImmutableMap instancesById = Maps.uniqueIndex(input, instanceToRegionAndName);
        for (Map.Entry entry : instancesById.entrySet()) {
            RegionAndName id = (RegionAndName)entry.getKey();
            RunningInstance instance = (RunningInstance)entry.getValue();
            try {
                this.logger.debug("<< allocating elastic IP instance(%s)", new Object[]{id});
                String ip = ((ElasticIPAddressApi)this.client.getElasticIPAddressApi().get()).allocateAddressInRegion(id.getRegion());
                this.logger.debug(">> awaiting status running instance(%s)", new Object[]{id});
                AtomicReference node = Atomics.newReference((Object)((NodeMetadata)this.runningInstanceToNodeMetadata.apply((Object)instance)));
                this.nodeRunning.apply((Object)node);
                this.logger.trace("<< running instance(%s)", new Object[]{id});
                this.logger.debug(">> associating elastic IP %s to instance %s", new Object[]{ip, id});
                ((ElasticIPAddressApi)this.client.getElasticIPAddressApi().get()).associateAddressInRegion(id.getRegion(), ip, id.getName());
                this.logger.trace("<< associated elastic IP %s to instance %s", new Object[]{ip, id});
                this.elasticIpCache.put((Object)id, (Object)ip);
            }
            catch (RuntimeException e) {
                badNodes.put((NodeMetadata)this.runningInstanceToNodeMetadata.apply((Object)((RunningInstance)instancesById.get(id))), e);
            }
        }
    }

    private Set<RunningInstance> createKeyPairAndSecurityGroupsAsNeededThenRunInstances(String group, int count, Template template) {
        String region = AWSUtils.getRegionFromLocationOrNull((Location)template.getLocation());
        String zone = EC2ComputeUtils.getZoneFromLocationOrNull(template.getLocation());
        RunInstancesOptions instanceOptions = this.createKeyPairAndSecurityGroupsAsNeededAndReturncustomize.execute(region, group, template);
        return this.createNodesInRegionAndZone(region, zone, group, count, template, instanceOptions);
    }

    protected Set<RunningInstance> createNodesInRegionAndZone(String region, String zone, String group, int count, Template template, RunInstancesOptions instanceOptions) {
        int countToProvision;
        int countStarted = 0;
        int tries = 0;
        ImmutableSet started = ImmutableSet.of();
        int maxCount = ((EC2TemplateOptions)EC2TemplateOptions.class.cast(template.getOptions())).getMaxCount();
        if (maxCount == 0) {
            maxCount = count;
            countToProvision = 1;
        } else {
            countToProvision = count;
        }
        while (countStarted < count && tries++ < count) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(">> running %d instance region(%s) zone(%s) ami(%s) params(%s)", new Object[]{count - countStarted, region, zone, template.getImage().getProviderId(), instanceOptions.buildFormParameters()});
            }
            if ((countStarted = Iterables.size((Iterable)(started = ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable)started, ((InstanceApi)this.client.getInstanceApi().get()).runInstancesInRegion(region, zone, template.getImage().getProviderId(), countToProvision, maxCount - countStarted, instanceOptions)))))) >= count) continue;
            this.logger.debug(">> not enough instances (%d/%d) started, attempting again", new Object[]{countStarted, count});
        }
        return started;
    }
}

