/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.strategy;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import jakarta.annotation.Resource;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.domain.Image;
import org.jclouds.ec2.features.AMIApi;
import org.jclouds.ec2.options.DescribeImagesOptions;
import org.jclouds.logging.Logger;

@Singleton
public class DescribeImagesParallel
implements Function<Iterable<Map.Entry<String, DescribeImagesOptions>>, Iterable<? extends Image>> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final EC2Api api;
    final ListeningExecutorService userExecutor;

    @Inject
    public DescribeImagesParallel(EC2Api api, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor) {
        this.api = api;
        this.userExecutor = userExecutor;
    }

    public Iterable<? extends Image> apply(Iterable<Map.Entry<String, DescribeImagesOptions>> queries) {
        ListenableFuture futures = Futures.allAsList((Iterable)Iterables.transform(queries, (Function)new Function<Map.Entry<String, DescribeImagesOptions>, ListenableFuture<? extends Set<? extends Image>>>(){

            public ListenableFuture<Set<? extends Image>> apply(final Map.Entry<String, DescribeImagesOptions> from) {
                return DescribeImagesParallel.this.userExecutor.submit((Callable)new Callable<Set<? extends Image>>(){

                    @Override
                    public Set<? extends Image> call() throws Exception {
                        return ((AMIApi)DescribeImagesParallel.this.api.getAMIApi().get()).describeImagesInRegion((String)from.getKey(), (DescribeImagesOptions)((Object)from.getValue()));
                    }
                });
            }
        }));
        this.logger.trace("amis", new Object[0]);
        return Iterables.concat((Iterable)((Iterable)Futures.getUnchecked((Future)futures)));
    }
}

