/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.loaders;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.Iterables;
import jakarta.annotation.Resource;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.domain.RegionNameAndIngressRules;
import org.jclouds.ec2.domain.SecurityGroup;
import org.jclouds.ec2.domain.UserIdGroupPair;
import org.jclouds.ec2.features.SecurityGroupApi;
import org.jclouds.logging.Logger;
import org.jclouds.net.domain.IpProtocol;

@Singleton
public class CreateSecurityGroupIfNeeded
extends CacheLoader<RegionAndName, String> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final SecurityGroupApi securityClient;
    protected final Predicate<RegionAndName> securityGroupEventualConsistencyDelay;

    @Inject
    public CreateSecurityGroupIfNeeded(EC2Api ec2Api, @Named(value="SECURITY") Predicate<RegionAndName> securityGroupEventualConsistencyDelay) {
        this((SecurityGroupApi)((EC2Api)Preconditions.checkNotNull((Object)ec2Api, (Object)"ec2Api")).getSecurityGroupApi().get(), securityGroupEventualConsistencyDelay);
    }

    public CreateSecurityGroupIfNeeded(SecurityGroupApi securityClient, @Named(value="SECURITY") Predicate<RegionAndName> securityGroupEventualConsistencyDelay) {
        this.securityClient = (SecurityGroupApi)Preconditions.checkNotNull((Object)securityClient, (Object)"securityClient");
        this.securityGroupEventualConsistencyDelay = (Predicate)Preconditions.checkNotNull(securityGroupEventualConsistencyDelay, (Object)"securityGroupEventualConsistencyDelay");
    }

    public String load(RegionAndName from) {
        RegionNameAndIngressRules realFrom = (RegionNameAndIngressRules)RegionNameAndIngressRules.class.cast(from);
        this.createSecurityGroupInRegion(from.getRegion(), from.getName(), realFrom.getPorts());
        return from.getName();
    }

    private void createSecurityGroupInRegion(String region, String name, int ... ports) {
        Preconditions.checkNotNull((Object)region, (Object)"region");
        Preconditions.checkNotNull((Object)name, (Object)"name");
        this.logger.debug(">> creating securityGroup region(%s) name(%s)", new Object[]{region, name});
        try {
            this.securityClient.createSecurityGroupInRegion(region, name, name);
            boolean created = this.securityGroupEventualConsistencyDelay.apply((Object)new RegionAndName(region, name));
            if (!created) {
                throw new RuntimeException(String.format("security group %s/%s is not available after creating", region, name));
            }
            this.logger.debug("<< created securityGroup(%s)", new Object[]{name});
            for (int port : ports) {
                this.createIngressRuleForTCPPort(region, name, port);
            }
            if (ports.length > 0) {
                this.authorizeGroupToItself(region, name);
            }
        }
        catch (IllegalStateException e) {
            this.logger.debug("<< reused securityGroup(%s)", new Object[]{name});
        }
    }

    protected void createIngressRuleForTCPPort(String region, String name, int port) {
        this.logger.debug(">> authorizing securityGroup region(%s) name(%s) port(%s)", new Object[]{region, name, port});
        this.securityClient.authorizeSecurityGroupIngressInRegion(region, name, IpProtocol.TCP, port, port, "0.0.0.0/0");
        this.logger.debug("<< authorized securityGroup(%s)", new Object[]{name});
    }

    protected void authorizeGroupToItself(String region, String name) {
        this.logger.debug(">> authorizing securityGroup region(%s) name(%s) permission to itself", new Object[]{region, name});
        String myOwnerId = ((SecurityGroup)((Object)Iterables.get(this.securityClient.describeSecurityGroupsInRegion(region, name), (int)0))).getOwnerId();
        this.securityClient.authorizeSecurityGroupIngressInRegion(region, name, new UserIdGroupPair(myOwnerId, name));
        this.logger.debug("<< authorized securityGroup(%s)", new Object[]{name});
    }
}

