/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.functions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import org.jclouds.compute.domain.Image;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.domain.KeyPair;
import org.jclouds.ec2.domain.RunningInstance;

@Singleton
public class CredentialsForInstance
extends CacheLoader<RunningInstance, Optional<LoginCredentials>> {
    private final ConcurrentMap<RegionAndName, KeyPair> credentialsMap;
    private final Supplier<LoadingCache<RegionAndName, ? extends Image>> imageMap;
    private final Function<RunningInstance, LoginCredentials> passwordCredentialsFromWindowsInstance;

    @Inject
    CredentialsForInstance(ConcurrentMap<RegionAndName, KeyPair> credentialsMap, Supplier<LoadingCache<RegionAndName, ? extends Image>> imageMap, Function<RunningInstance, LoginCredentials> passwordCredentialsFromWindowsInstance) {
        this.credentialsMap = (ConcurrentMap)Preconditions.checkNotNull(credentialsMap, (Object)"credentialsMap");
        this.imageMap = (Supplier)Preconditions.checkNotNull(imageMap, (Object)"imageMap");
        this.passwordCredentialsFromWindowsInstance = (Function)Preconditions.checkNotNull(passwordCredentialsFromWindowsInstance, (Object)"passwordCredentialsFromWindowsInstance");
    }

    public Optional<LoginCredentials> load(RunningInstance instance) throws ExecutionException {
        if ("windows".equals(instance.getPlatform())) {
            return Optional.of((Object)((LoginCredentials)this.passwordCredentialsFromWindowsInstance.apply((Object)instance)));
        }
        if (instance.getKeyName() != null) {
            return Optional.of((Object)LoginCredentials.builder().user(this.getLoginAccountFor(instance)).privateKey(this.getPrivateKeyOrNull(instance)).build());
        }
        return Optional.absent();
    }

    @VisibleForTesting
    String getPrivateKeyOrNull(RunningInstance instance) {
        KeyPair keyPair = (KeyPair)this.credentialsMap.get(new RegionAndName(instance.getRegion(), instance.getKeyName()));
        return keyPair != null ? keyPair.getKeyMaterial() : null;
    }

    @VisibleForTesting
    String getLoginAccountFor(RunningInstance from) throws ExecutionException {
        return ((Image)((LoadingCache)this.imageMap.get()).get((Object)new RegionAndName((String)from.getRegion(), (String)from.getImageId()))).getDefaultCredentials().identity;
    }
}

