/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.domain;

import com.google.common.base.Preconditions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.ssh.SshKeys;

public class KeyPair
implements Comparable<KeyPair> {
    private final String region;
    private final String keyName;
    private final String sha1OfPrivateKey;
    @Nullable
    private final String keyMaterial;
    @Nullable
    private final String fingerprint;

    public String toString() {
        return "[region=" + this.region + ", keyName=" + this.keyName + ", fingerprint=" + this.fingerprint + ", sha1OfPrivateKey=" + this.sha1OfPrivateKey + ", keyMaterial?=" + (this.keyMaterial != null) + "]";
    }

    public static Builder builder() {
        return new Builder();
    }

    public KeyPair(String region, String keyName, String sha1OfPrivateKey, @Nullable String keyMaterial, @Nullable String fingerprint) {
        this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"region");
        this.keyName = (String)Preconditions.checkNotNull((Object)keyName, (Object)"keyName");
        this.sha1OfPrivateKey = (String)Preconditions.checkNotNull((Object)sha1OfPrivateKey, (Object)"sha1OfPrivateKey");
        this.keyMaterial = keyMaterial;
        this.fingerprint = fingerprint;
    }

    @Deprecated
    public String getRegion() {
        return this.region;
    }

    @Override
    public int compareTo(KeyPair o) {
        return this == o ? 0 : this.getKeyName().compareTo(o.getKeyName());
    }

    public String getSha1OfPrivateKey() {
        return this.sha1OfPrivateKey;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public String getKeyMaterial() {
        return this.keyMaterial;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fingerprint == null ? 0 : this.fingerprint.hashCode());
        result = 31 * result + (this.keyMaterial == null ? 0 : this.keyMaterial.hashCode());
        result = 31 * result + (this.keyName == null ? 0 : this.keyName.hashCode());
        result = 31 * result + (this.region == null ? 0 : this.region.hashCode());
        result = 31 * result + (this.sha1OfPrivateKey == null ? 0 : this.sha1OfPrivateKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeyPair other = (KeyPair)obj;
        if (this.fingerprint == null ? other.fingerprint != null : !this.fingerprint.equals(other.fingerprint)) {
            return false;
        }
        if (this.keyMaterial == null ? other.keyMaterial != null : !this.keyMaterial.equals(other.keyMaterial)) {
            return false;
        }
        if (this.keyName == null ? other.keyName != null : !this.keyName.equals(other.keyName)) {
            return false;
        }
        if (this.region == null ? other.region != null : !this.region.equals(other.region)) {
            return false;
        }
        return !(this.sha1OfPrivateKey == null ? other.sha1OfPrivateKey != null : !this.sha1OfPrivateKey.equals(other.sha1OfPrivateKey));
    }

    public Builder toBuilder() {
        return Builder.fromKeyPair(this);
    }

    public static class Builder {
        private String region;
        private String keyName;
        private String fingerprint;
        private String sha1OfPrivateKey;
        private String keyMaterial;

        public Builder region(String region) {
            this.region = region;
            return this;
        }

        public Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public Builder sha1OfPrivateKey(String sha1OfPrivateKey) {
            this.sha1OfPrivateKey = sha1OfPrivateKey;
            return this;
        }

        public Builder keyMaterial(String keyMaterial) {
            this.keyMaterial = keyMaterial;
            return this;
        }

        public Builder fingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public KeyPair build() {
            if (this.fingerprint == null && this.keyMaterial != null) {
                this.fingerprint(SshKeys.fingerprintPrivateKey((String)this.keyMaterial));
            }
            return new KeyPair(this.region, this.keyName, this.sha1OfPrivateKey, this.keyMaterial, this.fingerprint);
        }

        public static Builder fromKeyPair(KeyPair in) {
            return new Builder().region(in.getRegion()).keyName(in.getKeyName()).sha1OfPrivateKey(in.getSha1OfPrivateKey()).keyMaterial(in.getKeyMaterial());
        }
    }
}

