/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.domain;

import com.google.auto.value.AutoValue;
import java.util.List;
import java.util.Map;
import org.jclouds.docker.domain.AutoValue_Network;
import org.jclouds.docker.domain.AutoValue_Network_Details;
import org.jclouds.docker.domain.AutoValue_Network_IPAM;
import org.jclouds.docker.domain.AutoValue_Network_IPAM_Config;
import org.jclouds.docker.internal.NullSafeCopies;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

@AutoValue
public abstract class Network {
    @Nullable
    public abstract String name();

    @Nullable
    public abstract String id();

    @Nullable
    public abstract String scope();

    @Nullable
    public abstract String driver();

    @Nullable
    public abstract IPAM ipam();

    @Nullable
    public abstract Map<String, Details> containers();

    @Nullable
    public abstract Map<String, String> options();

    Network() {
    }

    @SerializedNames(value={"Name", "Id", "Scope", "Driver", "IPAM", "Containers", "Options"})
    public static Network create(@Nullable String name, @Nullable String id, @Nullable String scope, @Nullable String driver, @Nullable IPAM ipam, @Nullable Map<String, Details> containers, @Nullable Map<String, String> options) {
        return Network.builder().name(name).id(id).scope(scope).driver(driver).ipam(ipam).containers(containers).options(options).build();
    }

    public static Builder builder() {
        return new AutoValue_Network.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder name(@Nullable String var1);

        public abstract Builder id(@Nullable String var1);

        public abstract Builder scope(@Nullable String var1);

        public abstract Builder driver(@Nullable String var1);

        public abstract Builder ipam(@Nullable IPAM var1);

        public abstract Builder containers(@Nullable Map<String, Details> var1);

        public abstract Builder options(@Nullable Map<String, String> var1);

        abstract Map<String, Details> containers();

        abstract Map<String, String> options();

        abstract Network autoBuild();

        public Network build() {
            return this.containers(NullSafeCopies.copyWithNullOf(this.containers())).options(NullSafeCopies.copyOf(this.options())).autoBuild();
        }
    }

    @AutoValue
    public static abstract class IPAM {
        IPAM() {
        }

        @Nullable
        public abstract String driver();

        public abstract List<Config> config();

        @SerializedNames(value={"Driver", "Config"})
        public static IPAM create(@Nullable String driver, List<Config> config) {
            return IPAM.builder().driver(driver).config(config).build();
        }

        public static Builder builder() {
            return new AutoValue_Network_IPAM.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder driver(@Nullable String var1);

            public abstract Builder config(List<Config> var1);

            abstract List<Config> config();

            abstract IPAM autoBuild();

            public IPAM build() {
                return this.config(NullSafeCopies.copyOf(this.config())).autoBuild();
            }
        }

        @AutoValue
        public static abstract class Config {
            Config() {
            }

            public abstract String subnet();

            @Nullable
            public abstract String ipRange();

            @Nullable
            public abstract String gateway();

            @SerializedNames(value={"Subnet", "IPRange", "Gateway"})
            public static Config create(String subnet, @Nullable String ipRange, @Nullable String gateway) {
                return Config.builder().subnet(subnet).ipRange(ipRange).gateway(gateway).build();
            }

            public static Builder builder() {
                return new AutoValue_Network_IPAM_Config.Builder();
            }

            @AutoValue.Builder
            public static abstract class Builder {
                public abstract Builder subnet(String var1);

                public abstract Builder ipRange(@Nullable String var1);

                public abstract Builder gateway(@Nullable String var1);

                abstract Config build();
            }
        }
    }

    @AutoValue
    public static abstract class Details {
        Details() {
        }

        public abstract String endpoint();

        public abstract String macAddress();

        public abstract String ipv4address();

        public abstract String ipv6address();

        @SerializedNames(value={"EndpointID", "MacAddress", "IPv4Address", "IPv6Address"})
        public static Details create(String endpoint, String macAddress, String ipv4address, String ipv6address) {
            return Details.builder().endpoint(endpoint).macAddress(macAddress).ipv4address(ipv4address).ipv6address(ipv6address).build();
        }

        public static Builder builder() {
            return new AutoValue_Network_Details.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder endpoint(String var1);

            public abstract Builder macAddress(String var1);

            public abstract Builder ipv4address(String var1);

            public abstract Builder ipv6address(String var1);

            abstract Details build();
        }
    }
}

