/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.domain;

import com.google.auto.value.AutoValue;
import java.util.List;
import org.jclouds.docker.domain.AutoValue_ExecCreateParams;
import org.jclouds.docker.internal.NullSafeCopies;
import org.jclouds.json.SerializedNames;

@AutoValue
public abstract class ExecCreateParams {
    public abstract boolean attachStdout();

    public abstract boolean attachStderr();

    public abstract List<String> cmd();

    @SerializedNames(value={"AttachStdout", "AttachStderr", "Cmd"})
    private static ExecCreateParams create(boolean attachStdout, boolean attachStderr, List<String> cmd) {
        return ExecCreateParams.builder().attachStdout(attachStdout).attachStderr(attachStderr).cmd(cmd).build();
    }

    public static Builder builder() {
        return new AutoValue_ExecCreateParams.Builder().attachStderr(true).attachStdout(true);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder attachStdout(boolean var1);

        public abstract Builder attachStderr(boolean var1);

        public abstract Builder cmd(List<String> var1);

        abstract List<String> cmd();

        abstract ExecCreateParams autoBuild();

        public ExecCreateParams build() {
            this.cmd(NullSafeCopies.copyOf(this.cmd()));
            return this.autoBuild();
        }
    }
}

