/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import jakarta.annotation.Resource;
import jakarta.inject.Named;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.logging.Logger;

public class ImageToImage
implements Function<org.jclouds.docker.domain.Image, Image> {
    private static final String CENTOS = "centos";
    private static final String UBUNTU = "ubuntu";
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;

    public Image apply(org.jclouds.docker.domain.Image from) {
        String osVersion;
        String name;
        Preconditions.checkNotNull((Object)from, (Object)"image");
        String firstRepoTag = (String)Iterables.getFirst(from.repoTags(), (Object)"<none>");
        int versionSeparatorPos = firstRepoTag.lastIndexOf(58);
        if (versionSeparatorPos > -1) {
            name = firstRepoTag.substring(0, versionSeparatorPos);
            osVersion = firstRepoTag.substring(versionSeparatorPos + 1);
        } else {
            name = firstRepoTag;
            osVersion = firstRepoTag;
        }
        this.logger.debug("os version for item: %s is %s", new Object[]{firstRepoTag, osVersion});
        OsFamily osFamily = (OsFamily)this.osFamily().apply((Object)firstRepoTag);
        OperatingSystem os = OperatingSystem.builder().description(firstRepoTag).family(osFamily).version(osVersion).is64Bit(this.is64bit(from)).build();
        return new ImageBuilder().ids(from.id()).name(name).description(firstRepoTag).operatingSystem(os).status(Image.Status.AVAILABLE).build();
    }

    private boolean is64bit(org.jclouds.docker.domain.Image inspectedImage) {
        if (inspectedImage.architecture() == null) {
            return true;
        }
        return inspectedImage.architecture().matches("x86_64|amd64");
    }

    private Function<String, OsFamily> osFamily() {
        return new Function<String, OsFamily>(){

            public OsFamily apply(String description) {
                if (description != null) {
                    if (description.contains(ImageToImage.CENTOS)) {
                        return OsFamily.CENTOS;
                    }
                    if (description.contains(ImageToImage.UBUNTU)) {
                        return OsFamily.UBUNTU;
                    }
                }
                return OsFamily.UNRECOGNIZED;
            }
        };
    }
}

