/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.compute.functions;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import org.jclouds.docker.compute.functions.LoginPortForContainer;
import org.jclouds.docker.domain.Container;

@Beta
public class CustomLoginPortFromImage
implements LoginPortForContainer {
    private final Map<String, Set<LoginPortForContainer>> imageToPortLookup;
    private static final Comparator<String> LongestStringFirst = new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            return s2.length() - s1.length();
        }
    };

    @Inject
    CustomLoginPortFromImage(Map<String, Set<LoginPortForContainer>> imageToPortLookup) {
        this.imageToPortLookup = imageToPortLookup;
    }

    public Optional<Integer> apply(final Container container) {
        Map matchingFunctions = Maps.filterKeys(this.imageToPortLookup, (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return container.config().image().matches(input);
            }
        });
        ArrayList sortedImages = new ArrayList(matchingFunctions.keySet());
        Collections.sort(sortedImages, LongestStringFirst);
        for (String currentImage : sortedImages) {
            Set functions = (Set)matchingFunctions.get(currentImage);
            for (LoginPortForContainer function : functions) {
                Optional port = (Optional)function.apply(container);
                if (!port.isPresent()) continue;
                return port;
            }
        }
        return Optional.absent();
    }
}

