/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import org.jclouds.cloudstack.domain.Volume;
import org.jclouds.cloudstack.options.AccountInDomainOptions;

public class ListVolumesOptions
extends AccountInDomainOptions {
    public static final ListVolumesOptions NONE = new ListVolumesOptions();

    public ListVolumesOptions hostId(String hostId) {
        this.queryParameters.replaceValues((Object)"hostid", (Iterable)ImmutableSet.of((Object)hostId));
        return this;
    }

    public ListVolumesOptions id(String id) {
        this.queryParameters.replaceValues((Object)"id", (Iterable)ImmutableSet.of((Object)id));
        return this;
    }

    public ListVolumesOptions isRecursive(boolean recursive) {
        this.queryParameters.replaceValues((Object)"isrecursive", (Iterable)ImmutableSet.of((Object)String.valueOf(recursive)));
        return this;
    }

    public ListVolumesOptions keyword(String keyword) {
        this.queryParameters.replaceValues((Object)"keyword", (Iterable)ImmutableSet.of((Object)keyword));
        return this;
    }

    public ListVolumesOptions name(String name) {
        this.queryParameters.replaceValues((Object)"name", (Iterable)ImmutableSet.of((Object)name));
        return this;
    }

    public ListVolumesOptions podId(String podId) {
        this.queryParameters.replaceValues((Object)"podid", (Iterable)ImmutableSet.of((Object)podId));
        return this;
    }

    public ListVolumesOptions type(Volume.Type type) {
        this.queryParameters.replaceValues((Object)"type", (Iterable)ImmutableSet.of((Object)type.toString()));
        return this;
    }

    public ListVolumesOptions virtualMachineId(String virtualMachineId) {
        this.queryParameters.replaceValues((Object)"virtualmachineid", (Iterable)ImmutableSet.of((Object)virtualMachineId));
        return this;
    }

    public ListVolumesOptions zoneId(String zoneId) {
        this.queryParameters.replaceValues((Object)"zoneid", (Iterable)ImmutableSet.of((Object)zoneId));
        return this;
    }

    public ListVolumesOptions projectId(String projectId) {
        this.queryParameters.replaceValues((Object)"projectid", (Iterable)ImmutableSet.of((Object)projectId));
        return this;
    }

    public ListVolumesOptions tags(Map<String, String> tags) {
        int count = 0;
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            this.queryParameters.replaceValues((Object)String.format("tags[%d].key", count), (Iterable)ImmutableSet.of((Object)entry.getKey()));
            this.queryParameters.replaceValues((Object)String.format("tags[%d].value", count), (Iterable)ImmutableSet.of((Object)entry.getValue()));
            ++count;
        }
        return this;
    }

    @Override
    public ListVolumesOptions accountInDomain(String account, String domain) {
        return (ListVolumesOptions)((Object)ListVolumesOptions.class.cast((Object)super.accountInDomain(account, domain)));
    }

    @Override
    public ListVolumesOptions domainId(String domainId) {
        return (ListVolumesOptions)((Object)ListVolumesOptions.class.cast((Object)super.domainId(domainId)));
    }

    public static class Builder {
        public static ListVolumesOptions accountInDomain(String account, String domain) {
            ListVolumesOptions options = new ListVolumesOptions();
            return options.accountInDomain(account, domain);
        }

        public static ListVolumesOptions domainId(String id) {
            ListVolumesOptions options = new ListVolumesOptions();
            return options.domainId(id);
        }

        public static ListVolumesOptions hostId(String id) {
            ListVolumesOptions options = new ListVolumesOptions();
            return options.hostId(id);
        }

        public static ListVolumesOptions id(String id) {
            ListVolumesOptions options = new ListVolumesOptions();
            return options.id(id);
        }

        public static ListVolumesOptions isRecursive(boolean recursive) {
            ListVolumesOptions options = new ListVolumesOptions();
            return options.isRecursive(recursive);
        }

        public static ListVolumesOptions keyword(String keyword) {
            ListVolumesOptions options = new ListVolumesOptions();
            return options.keyword(keyword);
        }

        public static ListVolumesOptions name(String name) {
            ListVolumesOptions options = new ListVolumesOptions();
            return options.name(name);
        }

        public static ListVolumesOptions podId(String id) {
            ListVolumesOptions options = new ListVolumesOptions();
            return options.podId(id);
        }

        public static ListVolumesOptions type(Volume.Type type) {
            ListVolumesOptions options = new ListVolumesOptions();
            return options.type(type);
        }

        public static ListVolumesOptions virtualMachineId(String virtualMachineId) {
            ListVolumesOptions options = new ListVolumesOptions();
            return options.virtualMachineId(virtualMachineId);
        }

        public static ListVolumesOptions zoneId(String id) {
            ListVolumesOptions options = new ListVolumesOptions();
            return options.zoneId(id);
        }

        public static ListVolumesOptions projectId(String id) {
            ListVolumesOptions options = new ListVolumesOptions();
            return options.projectId(id);
        }

        public static ListVolumesOptions tags(Map<String, String> tags) {
            ListVolumesOptions options = new ListVolumesOptions();
            return options.tags(tags);
        }
    }
}

