/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import org.jclouds.cloudstack.options.AccountInDomainOptions;

public class ListVirtualMachinesOptions
extends AccountInDomainOptions {
    public static final ListVirtualMachinesOptions NONE = new ListVirtualMachinesOptions();

    public ListVirtualMachinesOptions id(String id) {
        this.queryParameters.replaceValues((Object)"id", (Iterable)ImmutableSet.of((Object)id));
        return this;
    }

    public ListVirtualMachinesOptions name(String name) {
        this.queryParameters.replaceValues((Object)"name", (Iterable)ImmutableSet.of((Object)name));
        return this;
    }

    public ListVirtualMachinesOptions state(String state) {
        this.queryParameters.replaceValues((Object)"state", (Iterable)ImmutableSet.of((Object)state));
        return this;
    }

    public ListVirtualMachinesOptions groupId(String groupId) {
        this.queryParameters.replaceValues((Object)"groupid", (Iterable)ImmutableSet.of((Object)groupId));
        return this;
    }

    public ListVirtualMachinesOptions hostId(String hostId) {
        this.queryParameters.replaceValues((Object)"hostid", (Iterable)ImmutableSet.of((Object)hostId));
        return this;
    }

    public ListVirtualMachinesOptions networkId(String networkId) {
        this.queryParameters.replaceValues((Object)"networkid", (Iterable)ImmutableSet.of((Object)networkId));
        return this;
    }

    public ListVirtualMachinesOptions podId(String podId) {
        this.queryParameters.replaceValues((Object)"podid", (Iterable)ImmutableSet.of((Object)podId));
        return this;
    }

    public ListVirtualMachinesOptions projectId(String projectId) {
        this.queryParameters.replaceValues((Object)"projectid", (Iterable)ImmutableSet.of((Object)projectId));
        return this;
    }

    public ListVirtualMachinesOptions zoneId(String zoneId) {
        this.queryParameters.replaceValues((Object)"zoneid", (Iterable)ImmutableSet.of((Object)zoneId));
        return this;
    }

    public ListVirtualMachinesOptions usesVirtualNetwork(boolean usesVirtualNetwork) {
        this.queryParameters.replaceValues((Object)"forvirtualnetwork", (Iterable)ImmutableSet.of((Object)("" + usesVirtualNetwork)));
        return this;
    }

    public ListVirtualMachinesOptions tags(Map<String, String> tags) {
        int count = 0;
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            this.queryParameters.replaceValues((Object)String.format("tags[%d].key", count), (Iterable)ImmutableSet.of((Object)entry.getKey()));
            this.queryParameters.replaceValues((Object)String.format("tags[%d].value", count), (Iterable)ImmutableSet.of((Object)entry.getValue()));
            ++count;
        }
        return this;
    }

    @Override
    public ListVirtualMachinesOptions accountInDomain(String account, String domain) {
        return (ListVirtualMachinesOptions)((Object)ListVirtualMachinesOptions.class.cast((Object)super.accountInDomain(account, domain)));
    }

    @Override
    public ListVirtualMachinesOptions domainId(String domainId) {
        return (ListVirtualMachinesOptions)((Object)ListVirtualMachinesOptions.class.cast((Object)super.domainId(domainId)));
    }

    public static class Builder {
        public static ListVirtualMachinesOptions accountInDomain(String account, String domain) {
            ListVirtualMachinesOptions options = new ListVirtualMachinesOptions();
            return options.accountInDomain(account, domain);
        }

        public static ListVirtualMachinesOptions domainId(String id) {
            ListVirtualMachinesOptions options = new ListVirtualMachinesOptions();
            return options.domainId(id);
        }

        public static ListVirtualMachinesOptions id(String id) {
            ListVirtualMachinesOptions options = new ListVirtualMachinesOptions();
            return options.id(id);
        }

        public static ListVirtualMachinesOptions name(String name) {
            ListVirtualMachinesOptions options = new ListVirtualMachinesOptions();
            return options.name(name);
        }

        public static ListVirtualMachinesOptions state(String state) {
            ListVirtualMachinesOptions options = new ListVirtualMachinesOptions();
            return options.state(state);
        }

        public static ListVirtualMachinesOptions groupId(String id) {
            ListVirtualMachinesOptions options = new ListVirtualMachinesOptions();
            return options.groupId(id);
        }

        public static ListVirtualMachinesOptions hostId(String id) {
            ListVirtualMachinesOptions options = new ListVirtualMachinesOptions();
            return options.hostId(id);
        }

        public static ListVirtualMachinesOptions networkId(String id) {
            ListVirtualMachinesOptions options = new ListVirtualMachinesOptions();
            return options.networkId(id);
        }

        public static ListVirtualMachinesOptions podId(String id) {
            ListVirtualMachinesOptions options = new ListVirtualMachinesOptions();
            return options.podId(id);
        }

        public static ListVirtualMachinesOptions projectId(String id) {
            ListVirtualMachinesOptions options = new ListVirtualMachinesOptions();
            return options.projectId(id);
        }

        public static ListVirtualMachinesOptions zoneId(String id) {
            ListVirtualMachinesOptions options = new ListVirtualMachinesOptions();
            return options.zoneId(id);
        }

        public static ListVirtualMachinesOptions usesVirtualNetwork(boolean usesVirtualNetwork) {
            ListVirtualMachinesOptions options = new ListVirtualMachinesOptions();
            return options.usesVirtualNetwork(usesVirtualNetwork);
        }

        public static ListVirtualMachinesOptions tags(Map<String, String> tags) {
            ListVirtualMachinesOptions options = new ListVirtualMachinesOptions();
            return options.tags(tags);
        }
    }
}

