/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import org.jclouds.cloudstack.domain.NetworkType;
import org.jclouds.cloudstack.domain.TrafficType;
import org.jclouds.cloudstack.options.AccountInDomainOptions;

public class ListNetworksOptions
extends AccountInDomainOptions {
    public static final ListNetworksOptions NONE = new ListNetworksOptions();

    public ListNetworksOptions isDefault(boolean isDefault) {
        this.queryParameters.replaceValues((Object)"isdefault", (Iterable)ImmutableSet.of((Object)("" + isDefault)));
        return this;
    }

    public ListNetworksOptions isShared(boolean isShared) {
        this.queryParameters.replaceValues((Object)"isshared", (Iterable)ImmutableSet.of((Object)("" + isShared)));
        return this;
    }

    public ListNetworksOptions isSystem(boolean isSystem) {
        this.queryParameters.replaceValues((Object)"issystem", (Iterable)ImmutableSet.of((Object)("" + isSystem)));
        return this;
    }

    public ListNetworksOptions type(NetworkType type) {
        this.queryParameters.replaceValues((Object)"type", (Iterable)ImmutableSet.of((Object)type.toString()));
        return this;
    }

    public ListNetworksOptions id(String id) {
        this.queryParameters.replaceValues((Object)"id", (Iterable)ImmutableSet.of((Object)id));
        return this;
    }

    public ListNetworksOptions zoneId(String zoneId) {
        this.queryParameters.replaceValues((Object)"zoneid", (Iterable)ImmutableSet.of((Object)zoneId));
        return this;
    }

    public ListNetworksOptions projectId(String projectId) {
        this.queryParameters.replaceValues((Object)"projectid", (Iterable)ImmutableSet.of((Object)projectId));
        return this;
    }

    public ListNetworksOptions trafficType(TrafficType trafficType) {
        this.queryParameters.replaceValues((Object)"traffictype", (Iterable)ImmutableSet.of((Object)trafficType.toString()));
        return this;
    }

    @Override
    public ListNetworksOptions accountInDomain(String account, String domain) {
        return (ListNetworksOptions)((Object)ListNetworksOptions.class.cast((Object)super.accountInDomain(account, domain)));
    }

    @Override
    public ListNetworksOptions domainId(String domainId) {
        return (ListNetworksOptions)((Object)ListNetworksOptions.class.cast((Object)super.domainId(domainId)));
    }

    public ListNetworksOptions tags(Map<String, String> tags) {
        int count = 0;
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            this.queryParameters.replaceValues((Object)String.format("tags[%d].key", count), (Iterable)ImmutableSet.of((Object)entry.getKey()));
            this.queryParameters.replaceValues((Object)String.format("tags[%d].value", count), (Iterable)ImmutableSet.of((Object)entry.getValue()));
            ++count;
        }
        return this;
    }

    public static class Builder {
        public static ListNetworksOptions isDefault(boolean isDefault) {
            ListNetworksOptions options = new ListNetworksOptions();
            return options.isDefault(isDefault);
        }

        public static ListNetworksOptions isShared(boolean isShared) {
            ListNetworksOptions options = new ListNetworksOptions();
            return options.isShared(isShared);
        }

        public static ListNetworksOptions isSystem(boolean isSystem) {
            ListNetworksOptions options = new ListNetworksOptions();
            return options.isSystem(isSystem);
        }

        public static ListNetworksOptions type(NetworkType type) {
            ListNetworksOptions options = new ListNetworksOptions();
            return options.type(type);
        }

        public static ListNetworksOptions id(String id) {
            ListNetworksOptions options = new ListNetworksOptions();
            return options.id(id);
        }

        public static ListNetworksOptions zoneId(String id) {
            ListNetworksOptions options = new ListNetworksOptions();
            return options.zoneId(id);
        }

        public static ListNetworksOptions projectId(String id) {
            ListNetworksOptions options = new ListNetworksOptions();
            return options.projectId(id);
        }

        public static ListNetworksOptions trafficType(TrafficType trafficType) {
            ListNetworksOptions options = new ListNetworksOptions();
            return options.trafficType(trafficType);
        }

        public static ListNetworksOptions accountInDomain(String account, String domain) {
            ListNetworksOptions options = new ListNetworksOptions();
            return options.accountInDomain(account, domain);
        }

        public static ListNetworksOptions domainId(String domainId) {
            ListNetworksOptions options = new ListNetworksOptions();
            return options.domainId(domainId);
        }

        public static ListNetworksOptions tags(Map<String, String> tags) {
            ListNetworksOptions options = new ListNetworksOptions();
            return options.tags(tags);
        }
    }
}

