/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.functions;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Set;
import org.jclouds.cloudstack.CloudStackApi;
import org.jclouds.cloudstack.domain.FirewallRule;
import org.jclouds.cloudstack.options.ListFirewallRulesOptions;

@Singleton
public class GetFirewallRulesByVirtualMachine
extends CacheLoader<String, Set<FirewallRule>> {
    private final CloudStackApi client;

    @Inject
    public GetFirewallRulesByVirtualMachine(CloudStackApi client) {
        this.client = (CloudStackApi)Preconditions.checkNotNull((Object)client, (Object)"client");
    }

    public Set<FirewallRule> load(String input) {
        String publicIPId = this.client.getVirtualMachineApi().getVirtualMachine(input).getPublicIPId();
        ImmutableSet rules = this.client.getFirewallApi().listFirewallRules(ListFirewallRulesOptions.Builder.ipAddressId(publicIPId));
        return rules != null ? rules : ImmutableSet.of();
    }
}

