/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.filters;

import com.google.common.base.Supplier;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.jclouds.cloudstack.domain.LoginResponse;
import org.jclouds.cloudstack.filters.AuthenticationFilter;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;

@Singleton
public class AddSessionKeyAndJSessionIdToRequest
implements AuthenticationFilter {
    private final Supplier<LoginResponse> loginResponseSupplier;

    @Inject
    public AddSessionKeyAndJSessionIdToRequest(Supplier<LoginResponse> loginResponseSupplier) {
        this.loginResponseSupplier = loginResponseSupplier;
    }

    public HttpRequest filter(HttpRequest request) throws HttpException {
        LoginResponse loginResponse = (LoginResponse)this.loginResponseSupplier.get();
        HttpRequest.Builder builder = request.toBuilder();
        builder.replaceHeader("Cookie", new String[]{"JSESSIONID=" + loginResponse.getJSessionId()});
        builder.replaceQueryParam("sessionkey", new String[]{loginResponse.getSessionKey()});
        return builder.build();
    }
}

