/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.config;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.google.inject.AbstractModule;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.Date;
import org.jclouds.date.DateService;
import org.jclouds.json.config.GsonModule;
import org.jclouds.json.internal.NullFilteringTypeAdapterFactories;

public class CloudStackParserModule
extends AbstractModule {
    protected void configure() {
        this.bind(GsonModule.DateAdapter.class).to(CloudStackDateAdapter.class);
        this.bind(NullFilteringTypeAdapterFactories.IterableTypeAdapterFactory.class).to(CommaDelimitedOKIterableTypeAdapterFactory.class);
    }

    public static class CloudStackDateAdapter
    extends GsonModule.Iso8601DateAdapter {
        @Inject
        private CloudStackDateAdapter(DateService dateService) {
            super(dateService);
        }

        public Date read(JsonReader reader) throws IOException {
            return this.parseDate(reader.nextString().replaceAll("'T'", "T"));
        }
    }

    public static class CommaDelimitedOKIterableTypeAdapterFactory
    extends NullFilteringTypeAdapterFactories.IterableTypeAdapterFactory {
        protected <E, I> TypeAdapter<I> newAdapter(TypeAdapter<E> elementAdapter) {
            return new Adapter<E>(elementAdapter);
        }

        public static final class Adapter<E>
        extends TypeAdapter<Iterable<E>> {
            private final NullFilteringTypeAdapterFactories.IterableTypeAdapter<E> delegate;

            public Adapter(TypeAdapter<E> elementAdapter) {
                this.delegate = new NullFilteringTypeAdapterFactories.IterableTypeAdapter(elementAdapter);
                this.nullSafe();
            }

            public void write(JsonWriter out, Iterable<E> value) throws IOException {
                this.delegate.write(out, value);
            }

            public Iterable<E> read(JsonReader in) throws IOException {
                if (in.peek() == JsonToken.STRING) {
                    String val = Strings.emptyToNull((String)in.nextString());
                    return val != null ? Splitter.on((char)',').split((CharSequence)val) : ImmutableSet.of();
                }
                return this.delegate.read(in);
            }
        }
    }
}

