/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.memory;

import java.util.List;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.collections.IterableUtils;
import org.apache.jackrabbit.oak.commons.collections.ListUtils;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.plugins.memory.EmptyPropertyState;
import org.apache.jackrabbit.oak.plugins.value.Conversions;
import org.jetbrains.annotations.NotNull;

abstract class MultiPropertyState<T>
extends EmptyPropertyState {
    protected final List<T> values;

    protected MultiPropertyState(String name, Iterable<T> values) {
        super(name);
        this.values = ListUtils.toList(values);
    }

    public abstract Conversions.Converter getConverter(T var1);

    private <S> S convertTo(Type<S> type) {
        switch (type.tag()) {
            case 1: {
                return (S)IterableUtils.transform(this.values, value -> this.getConverter(value).toString());
            }
            case 2: {
                return (S)IterableUtils.transform(this.values, value -> this.getConverter(value).toBinary());
            }
            case 3: {
                return (S)IterableUtils.transform(this.values, value -> this.getConverter(value).toLong());
            }
            case 4: {
                return (S)IterableUtils.transform(this.values, value -> this.getConverter(value).toDouble());
            }
            case 5: {
                return (S)IterableUtils.transform(this.values, value -> this.getConverter(value).toDate());
            }
            case 6: {
                return (S)IterableUtils.transform(this.values, value -> this.getConverter(value).toBoolean());
            }
            case 7: {
                return (S)IterableUtils.transform(this.values, value -> this.getConverter(value).toString());
            }
            case 8: {
                return (S)IterableUtils.transform(this.values, value -> this.getConverter(value).toString());
            }
            case 9: {
                return (S)IterableUtils.transform(this.values, value -> this.getConverter(value).toString());
            }
            case 10: {
                return (S)IterableUtils.transform(this.values, value -> this.getConverter(value).toString());
            }
            case 11: {
                return (S)IterableUtils.transform(this.values, value -> this.getConverter(value).toString());
            }
            case 12: {
                return (S)IterableUtils.transform(this.values, value -> this.getConverter(value).toDecimal());
            }
        }
        throw new IllegalArgumentException("Unknown type:" + String.valueOf(type));
    }

    @NotNull
    public <S> S getValue(Type<S> type) {
        Validate.checkState((boolean)type.isArray(), (Object)"Type must be an array type");
        if (this.getType() == type) {
            return (S)this.values;
        }
        return this.convertTo(type);
    }

    private <S> S convertTo(Type<S> type, int index) {
        switch (type.tag()) {
            case 1: {
                return (S)this.getConverter(this.values.get(index)).toString();
            }
            case 2: {
                return (S)this.getConverter(this.values.get(index)).toBinary();
            }
            case 3: {
                return (S)Long.valueOf(this.getConverter(this.values.get(index)).toLong());
            }
            case 4: {
                return (S)Double.valueOf(this.getConverter(this.values.get(index)).toDouble());
            }
            case 5: {
                return (S)this.getConverter(this.values.get(index)).toString();
            }
            case 6: {
                return (S)Boolean.valueOf(this.getConverter(this.values.get(index)).toBoolean());
            }
            case 7: {
                return (S)this.getConverter(this.values.get(index)).toString();
            }
            case 8: {
                return (S)this.getConverter(this.values.get(index)).toString();
            }
            case 9: {
                return (S)this.getConverter(this.values.get(index)).toString();
            }
            case 10: {
                return (S)this.getConverter(this.values.get(index)).toString();
            }
            case 11: {
                return (S)this.getConverter(this.values.get(index)).toString();
            }
            case 12: {
                return (S)this.getConverter(this.values.get(index)).toDecimal();
            }
        }
        throw new IllegalArgumentException("Unknown type:" + String.valueOf(type));
    }

    @NotNull
    public <S> S getValue(Type<S> type, int index) {
        Validate.checkArgument((!type.isArray() ? 1 : 0) != 0, (String)"Type must not be an array type");
        if (this.getType().getBaseType() == type) {
            return (S)this.values.get(index);
        }
        return this.convertTo(type, index);
    }

    @Override
    public final int count() {
        return this.values.size();
    }

    @Override
    public long size(int index) {
        return ((String)this.convertTo(Type.STRING, index)).length();
    }
}

