/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.util;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoException;
import com.mongodb.ReadConcern;
import com.mongodb.ReadConcernLevel;
import com.mongodb.WriteConcern;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.ClusterType;
import com.mongodb.connection.ConnectionPoolSettings;
import com.mongodb.connection.ServerSettings;
import com.mongodb.connection.SocketSettings;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoConnection {
    private static final Logger LOG = LoggerFactory.getLogger(MongoConnection.class);
    public static final String MONGODB_PREFIX = "mongodb://";
    private static final Set<ReadConcernLevel> REPLICA_RC = Set.of(ReadConcernLevel.MAJORITY, ReadConcernLevel.LINEARIZABLE);
    private final ConnectionString mongoURI;
    private final MongoClient mongo;
    private static final String PROP_CLUSTER_DESCRIPTION_TIMEOUT_MS = "oak.mongo.clusterDescriptionTimeoutMs";
    private static final String PROP_CLUSTER_DESCRIPTION_INTERVAL_MS = "oak.mongo.clusterDescriptionIntervalMs";
    private static final long DEFAULT_CLUSTER_DESCRIPTION_TIMEOUT_MS = 5000L;
    private static final long DEFAULT_CLUSTER_DESCRIPTION_INTERVAL_MS = 100L;

    public MongoConnection(String uri) throws MongoException {
        this(uri, MongoConnection.getDefaultBuilder());
    }

    public MongoConnection(String uri, MongoClientSettings.Builder builder) throws MongoException {
        this.mongoURI = new ConnectionString(uri);
        builder.applyConnectionString(this.mongoURI);
        MongoClientSettings settings = builder.build();
        this.mongo = MongoClients.create((MongoClientSettings)settings);
    }

    public MongoConnection(String host, int port, String database) throws MongoException {
        this(MONGODB_PREFIX + host + ":" + port + "/" + database);
    }

    public MongoConnection(String uri, MongoClient client) {
        MongoClientSettings.Builder defaultBuilder = MongoConnection.getDefaultBuilder();
        this.mongoURI = new ConnectionString(uri);
        defaultBuilder.applyConnectionString(this.mongoURI);
        MongoClientSettings settings = defaultBuilder.build();
        this.mongo = MongoClients.create((MongoClientSettings)settings);
    }

    public ConnectionString getMongoURI() {
        return this.mongoURI;
    }

    public MongoClient getMongoClient() {
        return this.mongo;
    }

    public MongoDatabase getDatabase() {
        return this.mongo.getDatabase(this.mongoURI.getDatabase());
    }

    public MongoDatabase getDatabase(@NotNull String name) {
        return this.mongo.getDatabase(name);
    }

    public String getDBName() {
        return this.mongoURI.getDatabase();
    }

    public void close() {
        this.mongo.close();
    }

    public static MongoClientSettings.Builder getDefaultBuilder() {
        return MongoClientSettings.builder().applicationName("MongoConnection for Oak DocumentMK").applyToConnectionPoolSettings(poolBuilder -> poolBuilder.maxSize(100).minSize(0).maxConnecting(2).maxConnectionIdleTime(0L, TimeUnit.MILLISECONDS).maxConnectionLifeTime(0L, TimeUnit.MILLISECONDS).maxWaitTime(60000L, TimeUnit.MILLISECONDS)).applyToSocketSettings(socketBuilder -> socketBuilder.connectTimeout(10000L, TimeUnit.MILLISECONDS).readTimeout(0L, TimeUnit.MILLISECONDS)).applyToServerSettings(serverBuilder -> serverBuilder.heartbeatFrequency(5000L, TimeUnit.MILLISECONDS).minHeartbeatFrequency(500L, TimeUnit.MILLISECONDS)).applyToClusterSettings(clusterBuilder -> clusterBuilder.serverSelectionTimeout(30000L, TimeUnit.MILLISECONDS));
    }

    public static String toString(MongoClientSettings settings) {
        ConnectionPoolSettings poolSettings = settings.getConnectionPoolSettings();
        SocketSettings socketSettings = settings.getSocketSettings();
        ServerSettings serverSettings = settings.getServerSettings();
        ClusterSettings clusterSettings = settings.getClusterSettings();
        return new StringJoiner(", ", MongoClientSettings.class.getSimpleName() + "[", "]").add("pool.maxSize=" + poolSettings.getMaxSize()).add("pool.minSize=" + poolSettings.getMinSize()).add("pool.maxConnecting=" + poolSettings.getMaxConnecting()).add("pool.maxIdleTime=" + poolSettings.getMaxConnectionIdleTime(TimeUnit.MILLISECONDS)).add("pool.maxLifeTime=" + poolSettings.getMaxConnectionLifeTime(TimeUnit.MILLISECONDS)).add("pool.maxWaitTime=" + poolSettings.getMaxWaitTime(TimeUnit.MILLISECONDS)).add("socket.connectTimeout=" + socketSettings.getConnectTimeout(TimeUnit.MILLISECONDS)).add("socket.readTimeout=" + socketSettings.getReadTimeout(TimeUnit.MILLISECONDS)).add("server.heartbeatFreq=" + serverSettings.getHeartbeatFrequency(TimeUnit.MILLISECONDS)).add("server.minHeartbeatFreq=" + serverSettings.getMinHeartbeatFrequency(TimeUnit.MILLISECONDS)).add("cluster.serverSelectionTimeout=" + clusterSettings.getServerSelectionTimeout(TimeUnit.MILLISECONDS)).add("readPreference=" + settings.getReadPreference().getName()).add("writeConcern=" + String.valueOf(settings.getWriteConcern())).toString();
    }

    public static boolean hasWriteConcern(@NotNull String uri) {
        ConnectionString connectionString = new ConnectionString(Objects.requireNonNull(uri));
        return connectionString.getWriteConcern() != null;
    }

    public static boolean hasReadConcern(@NotNull String uri) {
        ConnectionString connectionString = new ConnectionString(Objects.requireNonNull(uri));
        MongoClientSettings.Builder builder = MongoClientSettings.builder().applyConnectionString(connectionString);
        MongoClientSettings settings = builder.build();
        return MongoConnection.readConcernLevel(settings.getReadConcern()) != null;
    }

    public static WriteConcern getDefaultWriteConcern(@NotNull MongoClient client) {
        long timeoutMs = Long.getLong(PROP_CLUSTER_DESCRIPTION_TIMEOUT_MS, 5000L);
        long intervalMs = Long.getLong(PROP_CLUSTER_DESCRIPTION_INTERVAL_MS, 100L);
        if (timeoutMs == 0L) {
            ClusterDescription clusterDescription = client.getClusterDescription();
            WriteConcern w = clusterDescription.getType() == ClusterType.REPLICA_SET ? WriteConcern.MAJORITY : WriteConcern.ACKNOWLEDGED;
            return w;
        }
        long startTime = System.currentTimeMillis();
        long endTime = startTime + timeoutMs;
        int attempts = 0;
        while (System.currentTimeMillis() < endTime) {
            ++attempts;
            ClusterDescription clusterDescription = client.getClusterDescription();
            if (clusterDescription.getType() == ClusterType.REPLICA_SET || clusterDescription.getType() == ClusterType.SHARDED) {
                return WriteConcern.MAJORITY;
            }
            if (clusterDescription.getType() == ClusterType.STANDALONE) {
                return WriteConcern.ACKNOWLEDGED;
            }
            try {
                Thread.sleep(intervalMs);
            }
            catch (InterruptedException interruptedException) {}
        }
        LOG.warn("Cluster description timeout after {}ms ({} attempts). Defaulting to ACKNOWLEDGED write concern.", (Object)timeoutMs, (Object)attempts);
        return WriteConcern.ACKNOWLEDGED;
    }

    public static ReadConcern getDefaultReadConcern(@NotNull MongoClient client, @NotNull MongoDatabase db) {
        ClusterDescription clusterDescription = Objects.requireNonNull(client).getClusterDescription();
        ReadConcern r = clusterDescription.getType() == ClusterType.REPLICA_SET && MongoConnection.isMajorityWriteConcern(db) ? ReadConcern.MAJORITY : ReadConcern.LOCAL;
        return r;
    }

    public static boolean isMajorityWriteConcern(@NotNull MongoDatabase db) {
        return WriteConcern.MAJORITY.getWString().equals(db.getWriteConcern().getWObject());
    }

    public static boolean isSufficientWriteConcern(@NotNull MongoClient client, @NotNull WriteConcern wc) {
        int w;
        Object wObj = Objects.requireNonNull(wc).getWObject();
        if (wObj instanceof Number) {
            w = ((Number)wObj).intValue();
        } else if (wObj == null) {
            w = 1;
        } else if (WriteConcern.MAJORITY.getWString().equals(wObj)) {
            w = 2;
        } else {
            throw new IllegalArgumentException("Unknown write concern: " + String.valueOf(wc));
        }
        ClusterDescription clusterDescription = client.getClusterDescription();
        if (clusterDescription.getType() == ClusterType.REPLICA_SET) {
            return w >= 2;
        }
        return w >= 1;
    }

    public static boolean isSufficientReadConcern(@NotNull MongoClient client, @NotNull ReadConcern rc) {
        ReadConcernLevel r = MongoConnection.readConcernLevel(Objects.requireNonNull(rc));
        ClusterDescription clusterDescription = client.getClusterDescription();
        if (clusterDescription.getType() != ClusterType.REPLICA_SET) {
            return true;
        }
        return Objects.nonNull(r) && REPLICA_RC.contains(r);
    }

    public static ReadConcernLevel readConcernLevel(ReadConcern readConcern) {
        if (readConcern.isServerDefault()) {
            return null;
        }
        return ReadConcernLevel.fromString((String)readConcern.asDocument().getString((Object)"level").getValue());
    }
}

