/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.StableRevisionComparator;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.jetbrains.annotations.NotNull;

public class UpdateUtils {
    public static void applyChanges(@NotNull Document doc, @NotNull UpdateOp update) {
        doc.put("_id", update.getId());
        for (Map.Entry<UpdateOp.Key, UpdateOp.Operation> e : Objects.requireNonNull(update).getChanges().entrySet()) {
            UpdateOp.Key k = e.getKey();
            UpdateOp.Operation op = e.getValue();
            switch (op.type) {
                case SET: {
                    doc.put(k.toString(), op.value);
                    break;
                }
                case REMOVE: {
                    doc.remove(k.toString());
                    break;
                }
                case MAX: {
                    Comparable newValue = (Comparable)op.value;
                    Object old = doc.get(k.toString());
                    if (old != null && newValue.compareTo(old) <= 0) break;
                    doc.put(k.toString(), op.value);
                    break;
                }
                case INCREMENT: {
                    Object old = doc.get(k.toString());
                    Long x = (Long)op.value;
                    if (old == null) {
                        old = 0L;
                    }
                    doc.put(k.toString(), (Long)old + x);
                    break;
                }
                case SET_MAP_ENTRY: {
                    Object old = doc.get(k.getName());
                    TreeMap<Revision, Object> m = (TreeMap<Revision, Object>)old;
                    if (m == null) {
                        m = new TreeMap<Revision, Object>(StableRevisionComparator.REVERSE);
                        doc.put(k.getName(), m);
                    }
                    if (k.getRevision() == null) {
                        throw new IllegalArgumentException("Cannot set map entry " + k.getName() + " with null revision");
                    }
                    m.put(k.getRevision(), op.value);
                    break;
                }
                case REMOVE_MAP_ENTRY: {
                    Object old = doc.get(k.getName());
                    TreeMap<Revision, Object> m = (Map)old;
                    if (m == null) break;
                    m.remove(k.getRevision());
                    break;
                }
            }
        }
    }

    public static boolean checkConditions(@NotNull Document doc, @NotNull Map<UpdateOp.Key, UpdateOp.Condition> conditions) {
        for (Map.Entry<UpdateOp.Key, UpdateOp.Condition> entry : conditions.entrySet()) {
            UpdateOp.Condition c = entry.getValue();
            UpdateOp.Key k = entry.getKey();
            Object value = doc.get(k.getName());
            Revision r = k.getRevision();
            if (c.type == UpdateOp.Condition.Type.EXISTS) {
                boolean checkForExistence = Boolean.TRUE.equals(c.value);
                if (value == null) {
                    if (!checkForExistence) continue;
                    return false;
                }
                if (r == null) {
                    if (checkForExistence) continue;
                    return false;
                }
                if (value instanceof Map) {
                    Map map = (Map)value;
                    if (!(checkForExistence ? !map.containsKey(r) : map.containsKey(r))) continue;
                    return false;
                }
                return false;
            }
            if (c.type == UpdateOp.Condition.Type.EQUALS || c.type == UpdateOp.Condition.Type.NOTEQUALS) {
                if (r != null) {
                    value = value instanceof Map ? ((Map)value).get(r) : null;
                }
                boolean equal = Objects.equals(value, c.value);
                if (c.type == UpdateOp.Condition.Type.EQUALS && !equal) {
                    return false;
                }
                if (c.type != UpdateOp.Condition.Type.NOTEQUALS || !equal) continue;
                return false;
            }
            throw new IllegalArgumentException("Unknown condition: " + String.valueOf((Object)c.type));
        }
        return true;
    }

    public static void assertUnconditional(@NotNull UpdateOp up) {
        Map<UpdateOp.Key, UpdateOp.Condition> conditions = up.getConditions();
        if (!conditions.isEmpty()) {
            throw new IllegalArgumentException("This DocumentStore method does not support conditional updates, but the UpdateOp contained: " + String.valueOf(conditions));
        }
    }
}

