/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.ArrayList;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sweep2StatusDocument {
    private static final Logger LOG = LoggerFactory.getLogger(Sweep2StatusDocument.class);
    static final String SWEEP2_STATUS_ID = "sweep2Status";
    private static final String STATUS_PROPERTY = "status";
    private static final String STATUS_VALUE_CHECKING = "checking";
    private static final String STATUS_VALUE_SWEEPING = "sweeping";
    private static final String STATUS_VALUE_SWEPT = "swept";
    private static final String LOCK_PROPERTY = "lock";
    private static final String MOD_COUNT_PROPERTY = "_modCount";
    private static final String SWEPT_BY_PROPERTY = "sweptBy";
    private final Document doc;

    public static Sweep2StatusDocument readFrom(DocumentStore documentStore) {
        Document doc = documentStore.find(Collection.SETTINGS, SWEEP2_STATUS_ID, -1);
        if (doc == null) {
            return null;
        }
        return new Sweep2StatusDocument(doc);
    }

    public static long acquireOrUpdateSweep2Lock(DocumentStore documentStore, int clusterId, boolean forceSweepingStatus) {
        Document existingStatusDoc = documentStore.find(Collection.SETTINGS, SWEEP2_STATUS_ID, -1);
        UpdateOp updateOp = new UpdateOp(SWEEP2_STATUS_ID, true);
        updateOp.set(LOCK_PROPERTY, clusterId);
        ArrayList<UpdateOp> updateOps = new ArrayList<UpdateOp>();
        updateOps.add(updateOp);
        if (existingStatusDoc == null) {
            updateOp.setNew(true);
            if (!forceSweepingStatus) {
                updateOp.set(STATUS_PROPERTY, STATUS_VALUE_CHECKING);
            } else {
                LOG.warn("acquireOrUpdateSweep2Lock: forced new sweep2 lock directly to state sweeping");
                updateOp.set(STATUS_PROPERTY, STATUS_VALUE_SWEEPING);
            }
            updateOp.set(MOD_COUNT_PROPERTY, 1L);
            if (!documentStore.create(Collection.SETTINGS, updateOps)) {
                LOG.info("acquireOrUpdateSweep2Lock: another instance just acquired the (new) sweep2 lock a few moments ago.");
                return 0L;
            }
            LOG.info("acquireOrUpdateSweep2Lock: sweep2 status set to " + (forceSweepingStatus ? STATUS_VALUE_SWEEPING : STATUS_VALUE_CHECKING) + ", locked for clusterId=" + clusterId);
            return 1L;
        }
        Sweep2StatusDocument existingStatus = new Sweep2StatusDocument(existingStatusDoc);
        if (existingStatus.isSwept()) {
            return -1L;
        }
        if (existingStatus.getLockClusterId() == clusterId && (!forceSweepingStatus || existingStatus.isSweeping())) {
            return existingStatus.getLockValue();
        }
        updateOp.setNew(false);
        if (forceSweepingStatus) {
            updateOp.set(STATUS_PROPERTY, STATUS_VALUE_SWEEPING);
        }
        updateOp.equals(MOD_COUNT_PROPERTY, existingStatusDoc.getModCount());
        long newModCount = existingStatusDoc.getModCount() + 1L;
        updateOp.set(MOD_COUNT_PROPERTY, newModCount);
        if (documentStore.findAndUpdate(Collection.SETTINGS, updateOp) == null) {
            LOG.info("acquireOrUpdateSweep2Lock: another instance just acquired the (expired) sweep2 lock a few moments ago");
            return 0L;
        }
        if (forceSweepingStatus) {
            LOG.info("acquireOrUpdateSweep2Lock: sweep2 status set to sweeping, relocked for clusterId=" + clusterId);
        } else {
            LOG.info("acquireOrUpdateSweep2Lock: sweep2 status unchanged (is " + String.valueOf(existingStatusDoc.get(STATUS_PROPERTY)) + "), relocked for clusterId=" + clusterId);
        }
        return newModCount;
    }

    public static boolean forceReleaseSweep2LockAndMarkSwept(DocumentStore documentStore, int clusterId) {
        Document existing = documentStore.find(Collection.SETTINGS, SWEEP2_STATUS_ID, -1);
        if (existing == null) {
            UpdateOp updateOp = new UpdateOp(SWEEP2_STATUS_ID, true);
            updateOp.set(STATUS_PROPERTY, STATUS_VALUE_SWEPT);
            updateOp.setNew(true);
            updateOp.set(MOD_COUNT_PROPERTY, 1L);
            updateOp.set(SWEPT_BY_PROPERTY, clusterId);
            ArrayList<UpdateOp> updateOps = new ArrayList<UpdateOp>();
            updateOps.add(updateOp);
            if (!documentStore.create(Collection.SETTINGS, updateOps)) {
                LOG.info("forceReleaseSweep2LockAndMarkSwept: another instance just wanted to mark sweep2 as done a few moments ago too.");
                return false;
            }
            LOG.info("forceReleaseSweep2LockAndMarkSwept: sweep2 status set to swept by clusterId=" + clusterId);
            return true;
        }
        if (new Sweep2StatusDocument(existing).isSwept()) {
            LOG.info("forceReleaseSweep2LockAndMarkSwept: sweep2 status was already marked swept previously");
            return true;
        }
        UpdateOp updateOp = new UpdateOp(SWEEP2_STATUS_ID, false);
        updateOp.set(STATUS_PROPERTY, STATUS_VALUE_SWEPT);
        updateOp.set(MOD_COUNT_PROPERTY, existing.getModCount() + 1L);
        updateOp.set(SWEPT_BY_PROPERTY, clusterId);
        if (existing.keySet().contains(LOCK_PROPERTY)) {
            updateOp.remove(LOCK_PROPERTY);
        }
        if (documentStore.findAndUpdate(Collection.SETTINGS, updateOp) == null) {
            LOG.info("forceReleaseSweep2LockAndMarkSwept: another instance just wanted to mark sweep2 as done a few moments ago too.");
            Sweep2StatusDocument status = Sweep2StatusDocument.readFrom(documentStore);
            if (status == null) {
                LOG.warn("forceReleaseSweep2LockAndMarkSwept: no existing sweep2 status after updating failed");
                return false;
            }
            return status.isSwept();
        }
        LOG.info("forceReleaseSweep2LockAndMarkSwept: sweep2 status set to swept by clusterId=" + clusterId);
        return true;
    }

    private Sweep2StatusDocument(Document doc) {
        this.doc = doc;
    }

    public boolean isSwept() {
        return STATUS_VALUE_SWEPT.equals(this.doc.get(STATUS_PROPERTY));
    }

    public boolean isSweeping() {
        return STATUS_VALUE_SWEEPING.equals(this.doc.get(STATUS_PROPERTY));
    }

    public boolean isChecking() {
        return STATUS_VALUE_CHECKING.equals(this.doc.get(STATUS_PROPERTY));
    }

    public int getLockClusterId() {
        return Integer.parseInt(String.valueOf(this.doc.get(LOCK_PROPERTY)));
    }

    public Integer getSweptById() {
        Object value = this.doc.get(SWEPT_BY_PROPERTY);
        if (value == null) {
            return null;
        }
        return Integer.parseInt(String.valueOf(value));
    }

    public long getLockValue() {
        return this.doc.getModCount();
    }

    public String toString() {
        return "Sweep2StatusDocument(status=" + String.valueOf(this.doc.get(STATUS_PROPERTY)) + ",lockClusterId=" + this.getLockClusterId() + ",lockValue=" + this.getLockValue() + ")";
    }
}

