/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.plugins.document.Commit;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Path;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CommitBuilder {
    static final Revision PSEUDO_COMMIT_REVISION = new Revision(Long.MIN_VALUE, 0, 0);
    private final DocumentNodeStore nodeStore;
    private final Revision revision;
    private final RevisionVector baseRevision;
    private RevisionVector startRevisions = new RevisionVector(new Revision[0]);
    private final Map<Path, UpdateOp> operations = new LinkedHashMap<Path, UpdateOp>();
    private final Set<Path> addedNodes = new HashSet<Path>();
    private final Set<Path> removedNodes = new HashSet<Path>();
    private final Set<Path> nodesWithBinaries = new HashSet<Path>();
    private final Map<Path, Path> bundledNodes = new HashMap<Path, Path>();

    CommitBuilder(@NotNull DocumentNodeStore nodeStore, @Nullable RevisionVector baseRevision) {
        this(nodeStore, PSEUDO_COMMIT_REVISION, baseRevision);
    }

    CommitBuilder(@NotNull DocumentNodeStore nodeStore, @NotNull Revision revision, @Nullable RevisionVector baseRevision) {
        this.nodeStore = Objects.requireNonNull(nodeStore);
        this.revision = Objects.requireNonNull(revision);
        this.baseRevision = baseRevision;
    }

    @NotNull
    Revision getRevision() {
        return this.revision;
    }

    @Nullable
    RevisionVector getBaseRevision() {
        return this.baseRevision;
    }

    @NotNull
    CommitBuilder addNode(@NotNull Path path) {
        this.addNode(new DocumentNodeState(this.nodeStore, path, new RevisionVector(this.revision)));
        return this;
    }

    @NotNull
    CommitBuilder addNode(@NotNull DocumentNodeState node) throws DocumentStoreException {
        Objects.requireNonNull(node);
        Path path = node.getPath();
        if (Utils.isNodeNameLong(path, this.nodeStore.getDocumentStore().getNodeNameLimit())) {
            throw new DocumentStoreException("Node name is too long: " + String.valueOf(path));
        }
        UpdateOp op = node.asOperation(this.revision);
        if (this.operations.containsKey(path)) {
            String msg = "Node already added: " + String.valueOf(path);
            throw new DocumentStoreException(msg);
        }
        if (this.isBranchCommit()) {
            NodeDocument.setBranchCommit(op, this.revision);
        }
        this.operations.put(path, op);
        this.addedNodes.add(path);
        return this;
    }

    @NotNull
    CommitBuilder addBundledNode(@NotNull Path path, @NotNull Path bundlingRootPath) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(bundlingRootPath);
        this.bundledNodes.put(path, bundlingRootPath);
        return this;
    }

    @NotNull
    CommitBuilder removeNode(@NotNull Path path, @NotNull NodeState state) throws DocumentStoreException {
        Objects.requireNonNull(path);
        Objects.requireNonNull(state);
        if (this.operations.containsKey(path)) {
            String msg = "Node already removed: " + String.valueOf(path);
            throw new DocumentStoreException(msg);
        }
        this.removedNodes.add(path);
        UpdateOp op = this.getUpdateOperationForNode(path);
        op.setDelete(true);
        NodeDocument.setDeleted(op, this.revision, true);
        for (PropertyState p : state.getProperties()) {
            this.updateProperty(path, p.getName(), null);
        }
        return this;
    }

    @NotNull
    CommitBuilder updateProperty(@NotNull Path path, @NotNull String propertyName, @Nullable String value) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(propertyName);
        UpdateOp op = this.getUpdateOperationForNode(path);
        String key = Utils.escapePropertyName(propertyName);
        op.setMapEntry(key, this.revision, value);
        return this;
    }

    @NotNull
    CommitBuilder markNodeHavingBinary(@NotNull Path path) {
        Objects.requireNonNull(path);
        this.nodesWithBinaries.add(path);
        return this;
    }

    @NotNull
    CommitBuilder withStartRevisions(@NotNull RevisionVector startRevisions) {
        this.startRevisions = Objects.requireNonNull(startRevisions);
        return this;
    }

    @NotNull
    Commit build() {
        if (PSEUDO_COMMIT_REVISION.equals(this.revision)) {
            String msg = "Cannot build a commit with a pseudo commit revision";
            throw new IllegalStateException(msg);
        }
        return new Commit(this.nodeStore, this.revision, this.baseRevision, this.startRevisions, this.operations, this.addedNodes, this.removedNodes, this.nodesWithBinaries, this.bundledNodes);
    }

    @NotNull
    Commit build(@NotNull Revision revision) {
        Objects.requireNonNull(revision);
        Revision from = this.revision;
        Map operations = this.operations.entrySet().stream().collect(LinkedHashMap::new, (m, e) -> m.put((Path)e.getKey(), CommitBuilder.rewrite((UpdateOp)e.getValue(), from, revision)), HashMap::putAll);
        return new Commit(this.nodeStore, revision, this.baseRevision, this.startRevisions, operations, this.addedNodes, this.removedNodes, this.nodesWithBinaries, this.bundledNodes);
    }

    int getNumOperations() {
        return this.operations.size();
    }

    private UpdateOp getUpdateOperationForNode(Path path) {
        UpdateOp op = this.operations.get(path);
        if (op == null) {
            op = CommitBuilder.createUpdateOp(path, this.revision, this.isBranchCommit());
            this.operations.put(path, op);
        }
        return op;
    }

    private static UpdateOp createUpdateOp(Path path, Revision revision, boolean isBranch) {
        String id = Utils.getIdFromPath(path);
        UpdateOp op = new UpdateOp(id, false);
        NodeDocument.setModified(op, revision);
        if (isBranch) {
            NodeDocument.setBranchCommit(op, revision);
        }
        return op;
    }

    private boolean isBranchCommit() {
        return this.baseRevision != null && this.baseRevision.isBranch();
    }

    private static UpdateOp rewrite(UpdateOp up, Revision from, Revision to) {
        HashMap<UpdateOp.Key, UpdateOp.Operation> changes = new HashMap<UpdateOp.Key, UpdateOp.Operation>();
        for (Map.Entry<UpdateOp.Key, UpdateOp.Operation> entry : up.getChanges().entrySet()) {
            UpdateOp.Key k = entry.getKey();
            UpdateOp.Operation op = entry.getValue();
            if (from.equals(k.getRevision())) {
                k = new UpdateOp.Key(k.getName(), to);
            } else if ("_modified".equals(k.getName())) {
                op = new UpdateOp.Operation(op.type, NodeDocument.getModifiedInSecs(to.getTimestamp()));
            }
            changes.put(k, op);
        }
        return new UpdateOp(up.getId(), up.isNew(), up.isDelete(), changes, null);
    }
}

