/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.search.spi.editor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.collections.IterableUtils;
import org.apache.jackrabbit.oak.plugins.index.IndexEditor;
import org.apache.jackrabbit.oak.plugins.index.search.Aggregate;
import org.apache.jackrabbit.oak.plugins.index.search.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.search.PropertyDefinition;
import org.apache.jackrabbit.oak.plugins.index.search.PropertyUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.search.spi.editor.FulltextIndexEditorContext;
import org.apache.jackrabbit.oak.plugins.index.search.spi.editor.FulltextIndexWriter;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.filter.PathFilter;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FulltextIndexEditor<D>
implements IndexEditor,
Aggregate.AggregateRoot {
    private static final Logger log = LoggerFactory.getLogger(FulltextIndexEditor.class);
    public static final String TEXT_EXTRACTION_ERROR = "TextExtractionError";
    private static final List<Aggregate.Matcher> EMPTY_AGGREGATE_MATCHER_LIST = List.of();
    private final FulltextIndexEditorContext<D> context;
    private final FulltextIndexEditor<D> parent;
    private final String path;
    private boolean propertiesChanged = false;
    private final List<PropertyState> propertiesModified = new ArrayList<PropertyState>();
    private final boolean isDeleted;
    private IndexDefinition.IndexingRule indexingRule;
    private List<Aggregate.Matcher> currentMatchers = List.of();
    private final MatcherState matcherState;
    private final PathFilter pathFilter;
    private final PathFilter.Result pathFilterResult;

    public FulltextIndexEditor(FulltextIndexEditorContext<D> context) {
        this.parent = null;
        this.path = "/";
        this.context = context;
        this.isDeleted = false;
        this.matcherState = MatcherState.NONE;
        this.pathFilter = context.getDefinition().getPathFilter();
        this.pathFilterResult = this.pathFilter.filter("/");
    }

    public FulltextIndexEditor(FulltextIndexEditor<D> parent, String path, MatcherState matcherState, PathFilter pathFilter, PathFilter.Result pathFilterResult, boolean isDeleted) {
        this.parent = parent;
        this.path = path;
        this.context = parent.context;
        this.isDeleted = isDeleted;
        this.matcherState = matcherState;
        this.pathFilter = pathFilter;
        this.pathFilterResult = pathFilterResult;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public void enter(NodeState before, NodeState after) {
        if (EmptyNodeState.MISSING_NODE == before && this.parent == null) {
            this.context.enableReindexMode();
        }
        if (this.pathFilterResult == PathFilter.Result.INCLUDE) {
            NodeState current = after.exists() ? after : before;
            this.indexingRule = this.getDefinition().getApplicableIndexingRule(current);
            if (this.indexingRule != null) {
                this.currentMatchers = this.indexingRule.getAggregate().createMatchers(this);
            }
        }
    }

    public void leave(NodeState before, NodeState after) throws CommitFailedException {
        long indexed;
        if ((this.propertiesChanged || !before.exists()) && this.addOrUpdate(this.path, after, before.exists()) && (indexed = this.context.incIndexedNodes()) % 1000L == 0L) {
            log.debug("[{}] => Indexed {} nodes...", (Object)this.getIndexName(), (Object)indexed);
        }
        BitSet bitSet = this.matcherState.affectedMatchers;
        int i = bitSet.nextSetBit(0);
        while (i != -1) {
            Aggregate.Matcher m = this.matcherState.matched.get(i);
            m.markRootDirty();
            i = bitSet.nextSetBit(i + 1);
        }
        if (this.parent == null) {
            PropertyUpdateCallback callback = this.context.getPropertyUpdateCallback();
            if (callback != null) {
                callback.done();
            }
            try {
                this.context.closeWriter();
            }
            catch (IOException e) {
                CommitFailedException ce = new CommitFailedException("Fulltext", 4, "Failed to close the Fulltext index " + this.context.getIndexingContext().getIndexPath(), (Throwable)e);
                this.context.getIndexingContext().indexUpdateFailed((Exception)ce);
                throw ce;
            }
            if (this.context.getIndexedNodes() > 0L) {
                log.debug("[{}] => Indexed {} nodes, done.", (Object)this.getIndexName(), (Object)this.context.getIndexedNodes());
            }
        }
    }

    public void propertyAdded(PropertyState after) {
        this.markPropertyChanged(after.getName());
        this.checkAggregates(after.getName());
        this.propertyUpdated(null, after);
    }

    public void propertyChanged(PropertyState before, PropertyState after) {
        this.markPropertyChanged(before.getName());
        if (this.isIndexable()) {
            this.propertiesModified.add(before);
        }
        this.checkAggregates(before.getName());
        this.propertyUpdated(before, after);
    }

    public void propertyDeleted(PropertyState before) {
        this.markPropertyChanged(before.getName());
        if (this.isIndexable()) {
            this.propertiesModified.add(before);
        }
        this.checkAggregates(before.getName());
        this.propertyUpdated(before, null);
    }

    public Editor childNodeAdded(String name, NodeState after) {
        String childPath = PathUtils.concat((String)this.path, (String)name);
        PathFilter.Result filterResult = this.pathFilter.filter(childPath);
        if (filterResult != PathFilter.Result.EXCLUDE) {
            return new FulltextIndexEditor<D>(this, childPath, this.getMatcherState(name, after), this.pathFilter, filterResult, false);
        }
        return null;
    }

    public Editor childNodeChanged(String name, NodeState before, NodeState after) {
        String childPath = PathUtils.concat((String)this.path, (String)name);
        PathFilter.Result filterResult = this.pathFilter.filter(childPath);
        if (filterResult != PathFilter.Result.EXCLUDE) {
            return new FulltextIndexEditor<D>(this, childPath, this.getMatcherState(name, after), this.pathFilter, filterResult, false);
        }
        return null;
    }

    public Editor childNodeDeleted(String name, NodeState before) throws CommitFailedException {
        MatcherState ms;
        String childPath = PathUtils.concat((String)this.path, (String)name);
        PathFilter.Result filterResult = this.pathFilter.filter(childPath);
        if (filterResult == PathFilter.Result.EXCLUDE) {
            return null;
        }
        if (!this.isDeleted) {
            try {
                FulltextIndexWriter<D> writer = this.context.getWriter();
                writer.deleteDocuments(childPath);
                this.context.indexUpdate();
            }
            catch (IOException e) {
                CommitFailedException ce = new CommitFailedException("Fulltext", 5, "Failed to remove the index entries of the removed subtree " + this.path + "for index " + this.context.getIndexingContext().getIndexPath(), (Throwable)e);
                this.context.getIndexingContext().indexUpdateFailed((Exception)ce);
                throw ce;
            }
        }
        if ((ms = this.getMatcherState(name, before)).isEmpty()) {
            return null;
        }
        return new FulltextIndexEditor<D>(this, childPath, ms, this.pathFilter, filterResult, true);
    }

    public FulltextIndexEditorContext<D> getContext() {
        return this.context;
    }

    private boolean addOrUpdate(String path, NodeState state, boolean isUpdate) throws CommitFailedException {
        try {
            D d = this.makeDocument(path, state, isUpdate);
            if (d != null) {
                if (log.isTraceEnabled()) {
                    log.trace("[{}] Indexed document for {} is {}", new Object[]{this.getIndexName(), path, d});
                }
                this.context.indexUpdate();
                this.context.getWriter().updateDocument(path, d);
                return true;
            }
        }
        catch (IOException e) {
            log.warn("Failed to index the node [{}] due to {}", (Object)path, (Object)e.toString());
            CommitFailedException ce = new CommitFailedException("Fulltext", 3, "Failed to index the node " + path, (Throwable)e);
            this.context.getIndexingContext().indexUpdateFailed((Exception)ce);
            throw ce;
        }
        catch (IllegalArgumentException ie) {
            log.warn("Failed to index the node [{}]", (Object)path, (Object)ie);
        }
        return false;
    }

    private D makeDocument(String path, NodeState state, boolean isUpdate) throws IOException {
        if (this.isIndexable()) {
            return this.context.newDocumentMaker(this.indexingRule, path).makeDocument(state, isUpdate, this.propertiesModified);
        }
        return null;
    }

    @Override
    public void markDirty() {
        this.propertiesChanged = true;
    }

    private MatcherState getMatcherState(String name, NodeState after) {
        if (this.matcherState.inherited.isEmpty() && this.currentMatchers.isEmpty()) {
            return MatcherState.NONE;
        }
        List<Aggregate.Matcher> matched = EMPTY_AGGREGATE_MATCHER_LIST;
        List<Aggregate.Matcher> inherited = EMPTY_AGGREGATE_MATCHER_LIST;
        for (Aggregate.Matcher m : IterableUtils.chainedIterable(this.matcherState.inherited, this.currentMatchers)) {
            Aggregate.Matcher result = m.match(name, after);
            if (result.getStatus() == Aggregate.Matcher.Status.MATCH_FOUND) {
                if (matched == EMPTY_AGGREGATE_MATCHER_LIST) {
                    matched = new ArrayList<Aggregate.Matcher>();
                }
                matched.add(result);
            }
            if (result.getStatus() == Aggregate.Matcher.Status.FAIL) continue;
            if (inherited == EMPTY_AGGREGATE_MATCHER_LIST) {
                inherited = new ArrayList<Aggregate.Matcher>();
            }
            result.nextSet(inherited);
        }
        if (matched.isEmpty() && inherited.isEmpty()) {
            return MatcherState.NONE;
        }
        return new MatcherState(matched, inherited);
    }

    private void checkAggregates(String name) {
        for (int i = 0; i < this.matcherState.matched.size(); ++i) {
            Aggregate.Matcher m;
            if (this.matcherState.affectedMatchers.get(i) || !(m = this.matcherState.matched.get(i)).aggregatesProperty(name)) continue;
            this.matcherState.affectedMatchers.set(i);
        }
    }

    private void markPropertyChanged(String name) {
        if (this.isIndexable() && !this.propertiesChanged && this.indexingRule.isIndexed(name)) {
            this.propertiesChanged = true;
        }
    }

    private void propertyUpdated(PropertyState before, PropertyState after) {
        PropertyDefinition pd;
        String propertyName;
        PropertyUpdateCallback callback = this.context.getPropertyUpdateCallback();
        if (callback == null) {
            return;
        }
        String string = propertyName = before != null ? before.getName() : after.getName();
        if (this.isIndexable() && (pd = this.indexingRule.getConfig(propertyName)) != null) {
            callback.propertyUpdated(this.path, propertyName, pd, before, after);
        }
        for (int i = 0; i < this.matcherState.matched.size(); ++i) {
            Aggregate.Include aggregateInclude;
            Aggregate.Matcher m = this.matcherState.matched.get(i);
            if (!m.aggregatesProperty(propertyName) || !((aggregateInclude = m.getCurrentInclude()) instanceof Aggregate.PropertyInclude)) continue;
            PropertyDefinition pd2 = ((Aggregate.PropertyInclude)aggregateInclude).getPropertyDefinition();
            String propertyRelativePath = PathUtils.concat((String)m.getMatchedPath(), (String)propertyName);
            callback.propertyUpdated(m.getRootPath(), propertyRelativePath, pd2, before, after);
        }
    }

    private IndexDefinition getDefinition() {
        return this.context.getDefinition();
    }

    private boolean isIndexable() {
        return this.indexingRule != null;
    }

    private String getIndexName() {
        return this.context.getDefinition().getIndexName();
    }

    public static class MatcherState {
        private static final BitSet EMPTY_BITSET = new BitSet(0);
        static final MatcherState NONE = new MatcherState(List.of(), List.of());
        final List<Aggregate.Matcher> matched;
        final List<Aggregate.Matcher> inherited;
        final BitSet affectedMatchers;

        public MatcherState(List<Aggregate.Matcher> matched, List<Aggregate.Matcher> inherited) {
            this.matched = matched;
            this.inherited = inherited;
            this.affectedMatchers = matched.isEmpty() ? EMPTY_BITSET : new BitSet(matched.size());
        }

        public boolean isEmpty() {
            return this.matched.isEmpty() && this.inherited.isEmpty();
        }
    }
}

