/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.search.spi.binary;

import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.plugins.index.FormattingUtils;
import org.apache.jackrabbit.oak.plugins.index.search.ExtractedTextCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TextExtractionStats {
    private static final Logger log = LoggerFactory.getLogger(TextExtractionStats.class);
    private static final long LOGGING_THRESHOLD = TimeUnit.MINUTES.toMillis(1L);
    private int numberOfExtractions;
    private long totalBytesRead;
    private long totalExtractedTextLength;
    private long totalExtractionTimeNanos;
    private long currentExtractionStartNanos = 0L;
    private long startTimeNanos = System.nanoTime();

    TextExtractionStats() {
    }

    public void reset() {
        this.numberOfExtractions = 0;
        this.totalBytesRead = 0L;
        this.totalExtractedTextLength = 0L;
        this.totalExtractionTimeNanos = 0L;
        this.currentExtractionStartNanos = 0L;
        this.startTimeNanos = System.nanoTime();
    }

    public void startExtraction() {
        this.currentExtractionStartNanos = System.nanoTime();
    }

    public void log(boolean reindex) {
        if (log.isDebugEnabled()) {
            log.debug("Text extraction stats {}", (Object)this);
        } else if (this.anyParsingDone() && (reindex || this.isTakingLotsOfTime())) {
            log.info("Text extraction stats {}", (Object)this);
        }
    }

    public long finishExtraction(long bytesRead, int extractedTextLength) {
        long elapsedNanos = System.nanoTime() - this.currentExtractionStartNanos;
        ++this.numberOfExtractions;
        this.totalBytesRead += bytesRead;
        this.totalExtractedTextLength += (long)extractedTextLength;
        this.totalExtractionTimeNanos += elapsedNanos;
        return elapsedNanos / 1000000L;
    }

    public void collectStats(ExtractedTextCache cache) {
        cache.addStats(this.numberOfExtractions, this.totalExtractionTimeNanos / 1000000L, this.totalBytesRead, this.totalExtractedTextLength);
    }

    private boolean isTakingLotsOfTime() {
        return this.totalExtractionTimeNanos > LOGGING_THRESHOLD * 1000000L;
    }

    private boolean anyParsingDone() {
        return this.numberOfExtractions > 0;
    }

    public String toString() {
        return String.format(" %d (Time Taken %s, Bytes Read %s, Extracted text size %s)", this.numberOfExtractions, TextExtractionStats.timeInWords(this.totalExtractionTimeNanos), IOUtils.humanReadableByteCount((long)this.totalBytesRead), IOUtils.humanReadableByteCount((long)this.totalExtractedTextLength));
    }

    public String formatStats() {
        long timeSinceStartNanos = System.nanoTime() - this.startTimeNanos;
        double timeExtractingPercentage = FormattingUtils.safeComputePercentage((long)this.totalExtractionTimeNanos, (long)timeSinceStartNanos);
        long avgExtractionTimeMillis = Math.round(FormattingUtils.safeComputeAverage((long)(this.totalExtractionTimeNanos / 1000000L), (long)this.numberOfExtractions));
        return String.format("extractions: %d, timeExtracting: %s (%2.1f%%), avgExtractionTime: %s ms, bytesRead: %s, extractedTextSize: %s", this.numberOfExtractions, FormattingUtils.formatNanosToSeconds((long)this.totalExtractionTimeNanos), timeExtractingPercentage, avgExtractionTimeMillis, IOUtils.humanReadableByteCount((long)this.totalBytesRead), IOUtils.humanReadableByteCount((long)this.totalExtractedTextLength));
    }

    private static String timeInWords(long millis) {
        return String.format("%d min, %d sec", TimeUnit.MILLISECONDS.toMinutes(millis), TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(millis)));
    }
}

