/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.search;

import javax.jcr.PropertyType;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.collections.IterableUtils;
import org.apache.jackrabbit.oak.commons.collections.ListUtils;
import org.apache.jackrabbit.oak.plugins.index.property.ValuePattern;
import org.apache.jackrabbit.oak.plugins.index.search.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.search.spi.query.FulltextIndexPlanner;
import org.apache.jackrabbit.oak.plugins.index.search.util.ConfigUtil;
import org.apache.jackrabbit.oak.plugins.index.search.util.FunctionIndexProcessor;
import org.apache.jackrabbit.oak.plugins.index.search.util.IndexHelper;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyDefinition {
    private static final Logger log = LoggerFactory.getLogger(PropertyDefinition.class);
    private static final String[] EMPTY_ANCESTORS = new String[0];
    static final float DEFAULT_BOOST = 1.0f;
    static final int SIMILARITY_SEARCH_DENSE_VECTOR_SIZE_DEFAULT = 1024;
    public final String name;
    public final String nodeName;
    private final int propertyType;
    public final float boost;
    public final boolean isRegexp;
    public final boolean index;
    public final boolean stored;
    public final boolean nodeScopeIndex;
    public final boolean propertyIndex;
    public final boolean analyzed;
    public final boolean ordered;
    public final boolean nullCheckEnabled;
    public final boolean notNullCheckEnabled;
    final int includedPropertyTypes;
    public final boolean relative;
    public final boolean useInSuggest;
    public final boolean useInSpellcheck;
    public final boolean facet;
    public final String[] ancestors;
    public final boolean excludeFromAggregate;
    public final int weight;
    public final boolean dynamicBoost;
    @Nullable
    public final String nonRelativeName;
    public final String function;
    public final String[] functionCode;
    public final ValuePattern valuePattern;
    public final boolean sync;
    public final boolean unique;
    public final boolean useInSimilarity;
    public final boolean similarityRerank;
    public final boolean similarityTags;
    private final int similaritySearchDVS;

    public PropertyDefinition(IndexDefinition.IndexingRule idxDefn, String nodeName, NodeState defn) {
        this.nodeName = nodeName;
        this.isRegexp = ConfigUtil.getOptionalValue(defn, "isRegexp", false);
        this.name = this.getNamePropertyValue(defn, nodeName);
        this.relative = PropertyDefinition.isRelativeProperty(this.name);
        this.boost = ConfigUtil.getOptionalValue(defn, "boost", 1.0f);
        this.weight = ConfigUtil.getOptionalValue(defn, "weight", FulltextIndexPlanner.DEFAULT_PROPERTY_WEIGHT);
        this.dynamicBoost = ConfigUtil.getOptionalValue(defn, "dynamicBoost", false);
        this.index = ConfigUtil.getOptionalValue(defn, "index", true);
        this.stored = this.getOptionalValueIfIndexed(defn, "useInExcerpt", false);
        this.nodeScopeIndex = this.getOptionalValueIfIndexed(defn, "nodeScopeIndex", false);
        this.analyzed = defn.hasProperty("boost") ? true : this.getOptionalValueIfIndexed(defn, "analyzed", false);
        this.ordered = this.getOptionalValueIfIndexed(defn, "ordered", false);
        this.includedPropertyTypes = IndexDefinition.getSupportedTypes(defn, "oak.experimental.includePropertyTypes", -1);
        this.propertyType = PropertyDefinition.getPropertyType(idxDefn, nodeName, defn);
        this.useInSuggest = this.getOptionalValueIfIndexed(defn, "useInSuggest", false);
        this.useInSpellcheck = this.getOptionalValueIfIndexed(defn, "useInSpellcheck", false);
        this.useInSimilarity = this.getOptionalValueIfIndexed(defn, "useInSimilarity", false);
        this.similarityRerank = this.getOptionalValueIfIndexed(defn, "similarityRerank", true);
        this.similarityTags = this.getOptionalValueIfIndexed(defn, "similarityTags", false);
        this.nullCheckEnabled = this.getOptionalValueIfIndexed(defn, "nullCheckEnabled", false);
        this.notNullCheckEnabled = this.getOptionalValueIfIndexed(defn, "notNullCheckEnabled", false);
        this.excludeFromAggregate = this.getOptionalValueIfIndexed(defn, "excludeFromAggregation", false);
        this.similaritySearchDVS = ConfigUtil.getOptionalValue(defn, "similaritySearchDenseVectorSize", 1024);
        this.nonRelativeName = this.determineNonRelativeName();
        this.ancestors = PropertyDefinition.computeAncestors(this.name);
        this.facet = this.getOptionalValueIfIndexed(defn, "facets", false);
        this.function = FunctionIndexProcessor.convertToPolishNotation(ConfigUtil.getOptionalValue(defn, "function", null));
        this.functionCode = FunctionIndexProcessor.getFunctionCode(this.function);
        this.valuePattern = new ValuePattern(defn);
        this.unique = this.getOptionalValueIfIndexed(defn, "unique", false);
        this.sync = this.unique || this.getOptionalValueIfIndexed(defn, "sync", false);
        this.propertyIndex = this.sync || this.getOptionalValueIfIndexed(defn, "propertyIndex", false);
        this.validate();
    }

    public boolean skipTokenization(String propertyName) {
        if (this.isRegexp && IndexHelper.skipTokenization(propertyName)) {
            return true;
        }
        return !this.analyzed;
    }

    public boolean fulltextEnabled() {
        return this.index && (this.analyzed || this.nodeScopeIndex);
    }

    public boolean propertyIndexEnabled() {
        return this.index && this.propertyIndex;
    }

    public boolean isTypeDefined() {
        return this.propertyType != 0;
    }

    public int getSimilaritySearchDenseVectorSize() {
        return this.similaritySearchDVS;
    }

    public int getType() {
        return this.isTypeDefined() ? this.propertyType : 1;
    }

    public boolean includePropertyType(int type) {
        return IndexDefinition.includePropertyType(this.includedPropertyTypes, type);
    }

    public String toString() {
        return "PropertyDefinition{name='" + this.name + "', propertyType=" + this.propertyType + ", boost=" + this.boost + ", isRegexp=" + this.isRegexp + ", index=" + this.index + ", stored=" + this.stored + ", nodeScopeIndex=" + this.nodeScopeIndex + ", propertyIndex=" + this.propertyIndex + ", analyzed=" + this.analyzed + ", ordered=" + this.ordered + ", useInSuggest=" + this.useInSuggest + ", useInSimilarity=" + this.useInSimilarity + ", nullCheckEnabled=" + this.nullCheckEnabled + ", notNullCheckEnabled=" + this.notNullCheckEnabled + ", function=" + this.function + "}";
    }

    static boolean isRelativeProperty(String propertyName) {
        return !PathUtils.isAbsolute((String)propertyName) && !"^[^\\/]*$".equals(propertyName) && PathUtils.getNextSlash((String)propertyName, (int)0) > 0;
    }

    private boolean getOptionalValueIfIndexed(NodeState definition, String propName, boolean defaultVal) {
        if (!this.index) {
            return false;
        }
        return ConfigUtil.getOptionalValue(definition, propName, defaultVal);
    }

    private void validate() {
        if (this.nullCheckEnabled && this.isRegexp) {
            throw new IllegalStateException(String.format("%s can be set to true for property definition using regular expression", "nullCheckEnabled"));
        }
    }

    private String determineNonRelativeName() {
        if (this.isRegexp) {
            return null;
        }
        if (!this.relative) {
            return this.name;
        }
        return PathUtils.getName((String)this.name);
    }

    private static String[] computeAncestors(String path) {
        if ("^[^\\/]*$".equals(path)) {
            return EMPTY_ANCESTORS;
        }
        return (String[])IterableUtils.toArray((Iterable)ListUtils.toList((Iterable)PathUtils.elements((String)PathUtils.getParentPath((String)path))), String.class);
    }

    protected String getNamePropertyValue(NodeState definition, String defaultName) {
        PropertyState ps = definition.getProperty("name");
        return ps == null ? defaultName : (String)ps.getValue(Type.STRING);
    }

    private static int getPropertyType(IndexDefinition.IndexingRule idxDefn, String name, NodeState defn) {
        int type = 0;
        if (defn.hasProperty("type")) {
            String typeName = defn.getString("type");
            try {
                type = PropertyType.valueFromName((String)typeName);
            }
            catch (IllegalArgumentException e) {
                log.warn("Invalid property type {} for property {} in Index {}", new Object[]{typeName, name, idxDefn});
            }
        }
        return type;
    }
}

