/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.collections.IterableUtils;
import org.apache.jackrabbit.oak.commons.collections.ListUtils;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.plugins.index.search.PropertyDefinition;
import org.apache.jackrabbit.oak.plugins.index.search.util.ConfigUtil;
import org.apache.jackrabbit.oak.plugins.memory.MemoryChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.jetbrains.annotations.Nullable;

public class Aggregate {
    public static final String MATCH_ALL = "*";
    public static final int RECURSIVE_AGGREGATION_LIMIT_DEFAULT = 5;
    private final String nodeTypeName;
    private final List<? extends Include> includes;
    public final int reAggregationLimit;
    private final NodeInclude[] relativeNodeIncludes;
    private final boolean nodeAggregates;

    public Aggregate(String nodeTypeName, List<? extends Include> includes) {
        this(nodeTypeName, includes, 5);
    }

    Aggregate(String nodeTypeName, List<? extends Include> includes, int recursionLimit) {
        this.nodeTypeName = nodeTypeName;
        this.includes = List.copyOf(includes);
        this.reAggregationLimit = recursionLimit;
        this.relativeNodeIncludes = Aggregate.findRelativeNodeIncludes(includes);
        this.nodeAggregates = this.includes.stream().anyMatch(input -> input instanceof NodeInclude);
    }

    public List<? extends Include> getIncludes() {
        return this.includes;
    }

    public void collectAggregates(NodeState root, ResultCollector collector) {
        if (Aggregate.matchingType(this.nodeTypeName, root)) {
            Matcher[] matchers = this.createMatchers();
            Aggregate.collectAggregates(root, matchers, collector);
        }
    }

    public List<Matcher> createMatchers(AggregateRoot root) {
        Matcher[] matchers = new Matcher[this.includes.size()];
        for (int i = 0; i < this.includes.size(); ++i) {
            matchers[i] = new Matcher(this, this.includes.get(i), root);
        }
        return Arrays.asList(matchers);
    }

    public boolean hasRelativeNodeInclude(String nodePath) {
        for (NodeInclude ni : this.relativeNodeIncludes) {
            if (!ni.matches(nodePath)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNodeAggregates() {
        return this.nodeAggregates;
    }

    public String toString() {
        return this.nodeTypeName;
    }

    private static boolean matchingType(String nodeTypeName, NodeState nodeState) {
        if (nodeTypeName.equals(ConfigUtil.getPrimaryTypeName(nodeState))) {
            return true;
        }
        for (String mixin : ConfigUtil.getMixinNames(nodeState)) {
            if (!nodeTypeName.equals(mixin)) continue;
            return true;
        }
        return false;
    }

    private static void collectAggregates(NodeState nodeState, Matcher[] matchers, ResultCollector collector) {
        if (Aggregate.hasPatternMatcher(matchers)) {
            Aggregate.collectAggregatesForPatternMatchers(nodeState, matchers, collector);
        } else {
            Aggregate.collectAggregatesForDirectMatchers(nodeState, matchers, collector);
        }
    }

    private static void collectAggregatesForDirectMatchers(NodeState nodeState, Matcher[] matchers, ResultCollector collector) {
        HashMap<String, MemoryChildNodeEntry> children = null;
        for (Matcher m : matchers) {
            String nodeName = m.getNodeName();
            NodeState child = nodeState.getChildNode(nodeName);
            if (!child.exists()) continue;
            if (children == null) {
                children = new HashMap<String, MemoryChildNodeEntry>();
            }
            children.put(nodeName, new MemoryChildNodeEntry(nodeName, child));
        }
        if (children != null) {
            Aggregate.matchChildren(matchers, collector, children.values());
        }
    }

    private static void collectAggregatesForPatternMatchers(NodeState nodeState, Matcher[] matchers, ResultCollector collector) {
        Aggregate.matchChildren(matchers, collector, nodeState.getChildNodeEntries());
    }

    private static void matchChildren(Matcher[] matchers, ResultCollector collector, Iterable<? extends ChildNodeEntry> children) {
        ArrayList nextSet = null;
        for (ChildNodeEntry childNodeEntry : children) {
            for (Matcher m : matchers) {
                Matcher result = m.match(childNodeEntry.getName(), childNodeEntry.getNodeState());
                if (result.getStatus() == Matcher.Status.MATCH_FOUND) {
                    result.collectResults(collector);
                }
                if (result.getStatus() == Matcher.Status.FAIL) continue;
                if (nextSet == null) {
                    nextSet = new ArrayList();
                }
                result.nextSet(nextSet);
            }
            if (nextSet == null || nextSet.isEmpty()) continue;
            Aggregate.collectAggregates(childNodeEntry.getNodeState(), nextSet.toArray(new Matcher[0]), collector);
            nextSet.clear();
        }
    }

    private static boolean hasPatternMatcher(Matcher[] matchers) {
        for (Matcher m : matchers) {
            if (!m.isPatternBased()) continue;
            return true;
        }
        return false;
    }

    private Matcher[] createMatchers() {
        Matcher[] matchers = new Matcher[this.includes.size()];
        for (int i = 0; i < this.includes.size(); ++i) {
            matchers[i] = new Matcher(this, this.includes.get(i));
        }
        return matchers;
    }

    private static NodeInclude[] findRelativeNodeIncludes(List<? extends Include> includes) {
        ArrayList<NodeInclude> result = new ArrayList<NodeInclude>();
        for (Include include : includes) {
            if (!(include instanceof NodeInclude)) continue;
            NodeInclude ni = (NodeInclude)include;
            if (!ni.relativeNode) continue;
            result.add(ni);
        }
        return result.toArray(new NodeInclude[0]);
    }

    private static String[] computeElements(String path) {
        return (String[])IterableUtils.toArray((Iterable)PathUtils.elements((String)path), String.class);
    }

    public static class Matcher {
        private final RootState rootState;
        private final Include currentInclude;
        private final int depth;
        private final Status status;
        private final NodeState matchedNodeState;
        private final String currentPath;
        private final List<String> aggregateStack;

        public Matcher(Aggregate aggregate, Include currentInclude) {
            this(aggregate, currentInclude, null);
        }

        public Matcher(Aggregate aggregate, Include include, AggregateRoot root) {
            this.rootState = new RootState(root, aggregate, include);
            this.depth = 0;
            this.currentInclude = include;
            this.status = Status.CONTINUE;
            this.currentPath = null;
            this.matchedNodeState = null;
            this.aggregateStack = List.of();
        }

        private Matcher(Matcher m, Status status, int depth) {
            Validate.checkArgument((status == Status.FAIL ? 1 : 0) != 0);
            this.rootState = m.rootState;
            this.depth = depth;
            this.currentInclude = m.currentInclude;
            this.status = status;
            this.currentPath = null;
            this.matchedNodeState = null;
            this.aggregateStack = m.aggregateStack;
        }

        private Matcher(Matcher m, Status status, int depth, NodeState matchedNodeState, String currentPath) {
            Validate.checkArgument((status != Status.FAIL ? 1 : 0) != 0);
            this.rootState = m.rootState;
            this.depth = depth;
            this.currentInclude = m.currentInclude;
            this.status = status;
            this.matchedNodeState = matchedNodeState;
            this.currentPath = currentPath;
            this.aggregateStack = m.aggregateStack;
        }

        private Matcher(Matcher m, Include i, String currentPath) {
            Validate.checkArgument((m.status == Status.MATCH_FOUND ? 1 : 0) != 0);
            this.rootState = m.rootState;
            this.depth = 0;
            this.currentInclude = i;
            this.status = Status.CONTINUE;
            this.matchedNodeState = null;
            this.currentPath = currentPath;
            ArrayList<String> paths = new ArrayList<String>(m.aggregateStack);
            paths.add(currentPath);
            this.aggregateStack = List.copyOf(paths);
        }

        public boolean isPatternBased() {
            return this.currentInclude.isPattern(this.depth);
        }

        public String getNodeName() {
            return this.currentInclude.getElementNameIfNotAPattern(this.depth);
        }

        public Matcher match(String name, NodeState nodeState) {
            boolean result = this.currentInclude.match(name, nodeState, this.depth);
            if (result) {
                if (this.hasMore()) {
                    return new Matcher(this, Status.CONTINUE, this.depth, nodeState, this.path(name));
                }
                return new Matcher(this, Status.MATCH_FOUND, this.depth, nodeState, this.path(name));
            }
            return new Matcher(this, Status.FAIL, this.depth);
        }

        public void nextSet(List<Matcher> destination) {
            Validate.checkArgument((this.status != Status.FAIL ? 1 : 0) != 0);
            if (this.status == Status.MATCH_FOUND) {
                Aggregate nextAgg = this.currentInclude.getAggregate(this.matchedNodeState);
                if (nextAgg != null) {
                    int recursionLevel = this.aggregateStack.size() + 1;
                    if (recursionLevel >= this.rootState.rootAggregate.reAggregationLimit) {
                        return;
                    }
                    for (int i = 0; i < nextAgg.includes.size(); ++i) {
                        destination.add(new Matcher(this, nextAgg.includes.get(i), this.currentPath));
                    }
                }
            } else {
                destination.add(new Matcher(this, this.status, this.depth + 1, null, this.currentPath));
            }
        }

        public void collectResults(ResultCollector results) {
            Validate.checkArgument((this.status == Status.MATCH_FOUND ? 1 : 0) != 0);
            String rootIncludePath = this.aggregateStack.isEmpty() ? this.currentPath : this.aggregateStack.get(0);
            this.currentInclude.collectResults(this.rootState.rootInclude, rootIncludePath, this.currentPath, this.matchedNodeState, results);
        }

        public void markRootDirty() {
            Validate.checkArgument((this.status == Status.MATCH_FOUND ? 1 : 0) != 0);
            this.rootState.root.markDirty();
        }

        public String getRootPath() {
            return this.rootState.root.getPath();
        }

        public String getMatchedPath() {
            Validate.checkArgument((this.status == Status.MATCH_FOUND ? 1 : 0) != 0);
            return this.currentPath;
        }

        public Include getCurrentInclude() {
            return this.currentInclude;
        }

        public Status getStatus() {
            return this.status;
        }

        public boolean aggregatesProperty(String name) {
            Validate.checkArgument((this.status == Status.MATCH_FOUND ? 1 : 0) != 0);
            return this.currentInclude.aggregatesProperty(name);
        }

        private boolean hasMore() {
            return this.depth < this.currentInclude.maxDepth() - 1;
        }

        private String path(String nodeName) {
            if (this.currentPath == null) {
                return nodeName;
            }
            return PathUtils.concat((String)this.currentPath, (String)nodeName);
        }

        private static class RootState {
            final AggregateRoot root;
            final Aggregate rootAggregate;
            final Include rootInclude;

            private RootState(AggregateRoot root, Aggregate rootAggregate, Include rootInclude) {
                this.root = root;
                this.rootAggregate = rootAggregate;
                this.rootInclude = rootInclude;
            }
        }

        public static enum Status {
            CONTINUE,
            MATCH_FOUND,
            FAIL;

        }
    }

    public static interface AggregateRoot {
        public void markDirty();

        public String getPath();
    }

    public static class PropertyIncludeResult {
        public final PropertyState propertyState;
        public final PropertyDefinition pd;
        public final String propertyPath;
        final String nodePath;

        public PropertyIncludeResult(PropertyState propertyState, PropertyDefinition pd, String parentPath) {
            this.propertyState = propertyState;
            this.pd = pd;
            this.nodePath = parentPath;
            this.propertyPath = PathUtils.concat((String)parentPath, (String)propertyState.getName());
        }
    }

    public static class NodeIncludeResult {
        public final NodeState nodeState;
        public final String nodePath;
        public final String rootIncludePath;

        public NodeIncludeResult(String nodePath, NodeState nodeState) {
            this(nodePath, null, nodeState);
        }

        public NodeIncludeResult(String nodePath, String rootIncludePath, NodeState nodeState) {
            this.nodePath = nodePath;
            this.nodeState = nodeState;
            this.rootIncludePath = rootIncludePath;
        }

        public boolean isRelativeNode() {
            return this.rootIncludePath != null;
        }

        public String toString() {
            return "NodeIncludeResult{nodePath='" + this.nodePath + "', rootIncludePath='" + this.rootIncludePath + "'}";
        }
    }

    public static interface ResultCollector {
        public void onResult(NodeIncludeResult var1);

        public void onResult(PropertyIncludeResult var1);
    }

    public static class FunctionInclude
    extends PropertyInclude {
        public FunctionInclude(PropertyDefinition pd) {
            super(pd);
        }

        @Override
        public void collectResults(String nodePath, NodeState nodeState, ResultCollector results) {
        }
    }

    public static class PropertyInclude
    extends Include {
        private final PropertyDefinition propertyDefinition;
        private final String propertyName;
        private final Pattern pattern;
        private final String parentPath;

        public PropertyInclude(PropertyDefinition pd) {
            super(PathUtils.getParentPath((String)pd.name));
            this.propertyDefinition = pd;
            this.propertyName = PathUtils.getName((String)pd.name);
            this.parentPath = PathUtils.getParentPath((String)pd.name);
            this.pattern = pd.isRegexp ? Pattern.compile(this.propertyName) : null;
        }

        @Override
        public void collectResults(String nodePath, NodeState nodeState, ResultCollector results) {
            if (this.pattern != null) {
                for (PropertyState ps : nodeState.getProperties()) {
                    if (NodeStateUtils.isHidden((String)ps.getName()) || !this.pattern.matcher(ps.getName()).matches()) continue;
                    results.onResult(new PropertyIncludeResult(ps, this.propertyDefinition, this.parentPath));
                }
            } else {
                PropertyState ps = nodeState.getProperty(this.propertyName);
                if (ps != null && !NodeStateUtils.isHidden((String)ps.getName())) {
                    results.onResult(new PropertyIncludeResult(ps, this.propertyDefinition, this.parentPath));
                }
            }
        }

        @Override
        public boolean aggregatesProperty(String name) {
            if (this.pattern != null) {
                return this.pattern.matcher(name).matches();
            }
            return this.propertyName.equals(name);
        }

        public String toString() {
            return this.propertyDefinition.toString();
        }

        public PropertyDefinition getPropertyDefinition() {
            return this.propertyDefinition;
        }
    }

    public static class NodeInclude
    extends Include {
        public final String primaryType;
        public final boolean relativeNode;
        private final String pattern;
        private final AggregateMapper aggMapper;

        public NodeInclude(AggregateMapper mapper, String pattern) {
            this(mapper, null, pattern, false);
        }

        public NodeInclude(AggregateMapper mapper, String primaryType, String pattern, boolean relativeNode) {
            super(pattern);
            this.pattern = pattern;
            this.primaryType = primaryType;
            this.aggMapper = mapper;
            this.relativeNode = relativeNode;
        }

        @Override
        public boolean match(String name, NodeState nodeState, int depth) {
            if (depth == this.maxDepth() - 1 && this.primaryType != null && !Aggregate.matchingType(this.primaryType, nodeState)) {
                return false;
            }
            return super.match(name, nodeState, depth);
        }

        @Override
        public void collectResults(Include include, String rootIncludePath, String nodePath, NodeState nodeState, ResultCollector results) {
            if (!(include instanceof NodeInclude)) {
                throw new IllegalArgumentException(String.valueOf(include));
            }
            NodeInclude rootInclude = (NodeInclude)include;
            if (rootInclude.relativeNode) {
                results.onResult(new NodeIncludeResult(nodePath, rootIncludePath, nodeState));
            }
            results.onResult(new NodeIncludeResult(nodePath, nodeState));
        }

        @Override
        public boolean aggregatesProperty(String name) {
            return true;
        }

        @Override
        public Aggregate getAggregate(NodeState matchedNodeState) {
            Aggregate agg;
            block1: {
                String mixin;
                agg = this.aggMapper.getAggregate(ConfigUtil.getPrimaryTypeName(matchedNodeState));
                if (agg != null) break block1;
                Iterator<String> iterator = ConfigUtil.getMixinNames(matchedNodeState).iterator();
                while (iterator.hasNext() && (agg = this.aggMapper.getAggregate(mixin = iterator.next())) == null) {
                }
            }
            return agg;
        }

        public String toString() {
            return "NodeInclude{primaryType='" + this.primaryType + "', relativeNode=" + this.relativeNode + ", pattern='" + this.pattern + "'}";
        }

        public boolean matches(String nodePath) {
            List pathElements = ListUtils.toList((Iterable)PathUtils.elements((String)nodePath));
            if (pathElements.size() != this.elements.length) {
                return false;
            }
            for (int i = 0; i < this.elements.length; ++i) {
                String element = this.elements[i];
                if (Aggregate.MATCH_ALL.equals(element) || element.equals(pathElements.get(i))) continue;
                return false;
            }
            return true;
        }
    }

    public static abstract class Include {
        protected final String[] elements;

        public Include(String pattern) {
            this.elements = Aggregate.computeElements(pattern);
        }

        public boolean match(String name, NodeState nodeState, int depth) {
            String element = this.elements[depth];
            if (Aggregate.MATCH_ALL.equals(element)) {
                return true;
            }
            return element.equals(name);
        }

        public int maxDepth() {
            return this.elements.length;
        }

        public void collectResults(Include rootInclude, String rootIncludePath, String nodePath, NodeState nodeState, ResultCollector results) {
            this.collectResults(nodePath, nodeState, results);
        }

        public void collectResults(String nodePath, NodeState nodeState, ResultCollector results) {
        }

        public abstract boolean aggregatesProperty(String var1);

        @Nullable
        public Aggregate getAggregate(NodeState matchedNodeState) {
            return null;
        }

        public boolean isPattern(int depth) {
            return Aggregate.MATCH_ALL.equals(this.elements[depth]);
        }

        public String getElementNameIfNotAPattern(int depth) {
            if (this.isPattern(depth)) {
                throw new IllegalArgumentException("Element at " + depth + " is pattern instead of specific name in " + Arrays.toString(this.elements));
            }
            return this.elements[depth];
        }
    }

    public static interface AggregateMapper {
        @Nullable
        public Aggregate getAggregate(String var1);
    }
}

