/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.search.util;

public class QueryUtils {
    public static final char WILDCARD_STRING = '*';
    public static final char WILDCARD_CHAR = '?';
    public static final char WILDCARD_ESCAPE = '\\';

    private static void replaceWildcard(StringBuilder sb, int position, char oldWildcard, char newWildcard) {
        if (sb.charAt(position) == oldWildcard) {
            int escapeCount = 0;
            int m = position - 1;
            while (m >= 0 && sb.charAt(m) == '\\') {
                --m;
                ++escapeCount;
            }
            if (escapeCount % 2 == 0) {
                sb.setCharAt(position, newWildcard);
            }
        }
    }

    public static String sqlLikeToLuceneWildcardQuery(String likePattern) {
        StringBuilder firstBuilder = new StringBuilder(likePattern);
        for (int k = 0; k < firstBuilder.length(); ++k) {
            QueryUtils.replaceWildcard(firstBuilder, k, '%', '*');
            QueryUtils.replaceWildcard(firstBuilder, k, '_', '?');
        }
        return firstBuilder.toString();
    }
}

