/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.search.util;

import java.util.Collections;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.collections.IterableUtils;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.Nullable;

public class ConfigUtil {
    private static final String ILLEGAL_STATE_EXCEPTION_ERROR_MESSAGE = "Multiple values provided for property %s in index definition . Single value was expected";

    public static boolean getOptionalValue(NodeState definition, String propName, boolean defaultVal) {
        try {
            PropertyState ps = definition.getProperty(propName);
            return ps == null ? defaultVal : (Boolean)ps.getValue(Type.BOOLEAN);
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException(String.format(ILLEGAL_STATE_EXCEPTION_ERROR_MESSAGE, propName), e);
        }
    }

    public static int getOptionalValue(NodeState definition, String propName, int defaultVal) {
        try {
            PropertyState ps = definition.getProperty(propName);
            return ps == null ? defaultVal : Math.toIntExact((Long)ps.getValue(Type.LONG));
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException(String.format(ILLEGAL_STATE_EXCEPTION_ERROR_MESSAGE, propName), e);
        }
    }

    public static String getOptionalValue(NodeState definition, String propName, String defaultVal) {
        try {
            PropertyState ps = definition.getProperty(propName);
            return ps == null ? defaultVal : (String)ps.getValue(Type.STRING);
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException(String.format(ILLEGAL_STATE_EXCEPTION_ERROR_MESSAGE, propName), e);
        }
    }

    public static float getOptionalValue(NodeState definition, String propName, float defaultVal) {
        try {
            PropertyState ps = definition.getProperty(propName);
            return ps == null ? defaultVal : ((Double)ps.getValue(Type.DOUBLE)).floatValue();
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException(String.format(ILLEGAL_STATE_EXCEPTION_ERROR_MESSAGE, propName), e);
        }
    }

    public static double getOptionalValue(NodeState definition, String propName, double defaultVal) {
        try {
            PropertyState ps = definition.getProperty(propName);
            return ps == null ? defaultVal : (Double)ps.getValue(Type.DOUBLE);
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException(String.format(ILLEGAL_STATE_EXCEPTION_ERROR_MESSAGE, propName), e);
        }
    }

    public static long getOptionalValue(NodeState definition, String propName, long defaultVal) {
        try {
            PropertyState ps = definition.getProperty(propName);
            return ps == null ? defaultVal : (Long)ps.getValue(Type.LONG);
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException(String.format(ILLEGAL_STATE_EXCEPTION_ERROR_MESSAGE, propName), e);
        }
    }

    public static String getPrimaryTypeName(NodeState nodeState) {
        try {
            PropertyState ps = nodeState.getProperty("jcr:primaryType");
            return ps == null ? "nt:base" : (String)ps.getValue(Type.NAME);
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException(String.format(ILLEGAL_STATE_EXCEPTION_ERROR_MESSAGE, "jcr:primaryType"), e);
        }
    }

    public static Iterable<String> getMixinNames(NodeState nodeState) {
        PropertyState ps = nodeState.getProperty("jcr:mixinTypes");
        return ps == null ? Collections.emptyList() : (Iterable)ps.getValue(Type.NAMES);
    }

    @Nullable
    public static Blob getBlob(NodeState state, String resourceName) {
        NodeState contentNode = state.getChildNode("jcr:content");
        Validate.checkArgument((boolean)contentNode.exists(), (String)"Was expecting to find jcr:content node to read resource %s", (Object[])new Object[]{resourceName});
        PropertyState property = contentNode.getProperty("jcr:data");
        return property != null ? (Blob)property.getValue(Type.BINARY) : null;
    }

    public static <T> T[] getOptionalValues(NodeState definition, String propName, Type<Iterable<T>> type, Class<T> typeParam) {
        return ConfigUtil.getOptionalValues(definition, propName, type, typeParam, null);
    }

    public static <T> T[] getOptionalValues(NodeState definition, String propName, Type<Iterable<T>> type, Class<T> typeParam, T[] defaultValues) {
        PropertyState ps = definition.getProperty(propName);
        if (ps != null) {
            return IterableUtils.toArray((Iterable)((Iterable)ps.getValue(type)), typeParam);
        }
        return defaultValues;
    }
}

